/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestServiceQuotaIncreaseRequest extends ServiceQuotasRequest implements
        ToCopyableBuilder<RequestServiceQuotaIncreaseRequest.Builder, RequestServiceQuotaIncreaseRequest> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceCode").getter(getter(RequestServiceQuotaIncreaseRequest::serviceCode))
            .setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()).build();

    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuotaCode").getter(getter(RequestServiceQuotaIncreaseRequest::quotaCode))
            .setter(setter(Builder::quotaCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaCode").build()).build();

    private static final SdkField<Double> DESIRED_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DesiredValue").getter(getter(RequestServiceQuotaIncreaseRequest::desiredValue))
            .setter(setter(Builder::desiredValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredValue").build()).build();

    private static final SdkField<String> CONTEXT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContextId").getter(getter(RequestServiceQuotaIncreaseRequest::contextId))
            .setter(setter(Builder::contextId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD,
            QUOTA_CODE_FIELD, DESIRED_VALUE_FIELD, CONTEXT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ServiceCode", SERVICE_CODE_FIELD);
                    put("QuotaCode", QUOTA_CODE_FIELD);
                    put("DesiredValue", DESIRED_VALUE_FIELD);
                    put("ContextId", CONTEXT_ID_FIELD);
                }
            });

    private final String serviceCode;

    private final String quotaCode;

    private final Double desiredValue;

    private final String contextId;

    private RequestServiceQuotaIncreaseRequest(BuilderImpl builder) {
        super(builder);
        this.serviceCode = builder.serviceCode;
        this.quotaCode = builder.quotaCode;
        this.desiredValue = builder.desiredValue;
        this.contextId = builder.contextId;
    }

    /**
     * <p>
     * Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the
     * <a>ListServices</a> operation.
     * </p>
     * 
     * @return Specifies the service identifier. To find the service code value for an Amazon Web Services service, use
     *         the <a>ListServices</a> operation.
     */
    public final String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * Specifies the quota identifier. To find the quota code for a specific quota, use the <a>ListServiceQuotas</a>
     * operation, and look for the <code>QuotaCode</code> response in the output for the quota you want.
     * </p>
     * 
     * @return Specifies the quota identifier. To find the quota code for a specific quota, use the
     *         <a>ListServiceQuotas</a> operation, and look for the <code>QuotaCode</code> response in the output for
     *         the quota you want.
     */
    public final String quotaCode() {
        return quotaCode;
    }

    /**
     * <p>
     * Specifies the new, increased value for the quota.
     * </p>
     * 
     * @return Specifies the new, increased value for the quota.
     */
    public final Double desiredValue() {
        return desiredValue;
    }

    /**
     * <p>
     * Specifies the Amazon Web Services account or resource to which the quota applies. The value in this field depends
     * on the context scope associated with the specified service quota.
     * </p>
     * 
     * @return Specifies the Amazon Web Services account or resource to which the quota applies. The value in this field
     *         depends on the context scope associated with the specified service quota.
     */
    public final String contextId() {
        return contextId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(quotaCode());
        hashCode = 31 * hashCode + Objects.hashCode(desiredValue());
        hashCode = 31 * hashCode + Objects.hashCode(contextId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestServiceQuotaIncreaseRequest)) {
            return false;
        }
        RequestServiceQuotaIncreaseRequest other = (RequestServiceQuotaIncreaseRequest) obj;
        return Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(quotaCode(), other.quotaCode())
                && Objects.equals(desiredValue(), other.desiredValue()) && Objects.equals(contextId(), other.contextId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestServiceQuotaIncreaseRequest").add("ServiceCode", serviceCode())
                .add("QuotaCode", quotaCode()).add("DesiredValue", desiredValue()).add("ContextId", contextId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "QuotaCode":
            return Optional.ofNullable(clazz.cast(quotaCode()));
        case "DesiredValue":
            return Optional.ofNullable(clazz.cast(desiredValue()));
        case "ContextId":
            return Optional.ofNullable(clazz.cast(contextId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RequestServiceQuotaIncreaseRequest, T> g) {
        return obj -> g.apply((RequestServiceQuotaIncreaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceQuotasRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RequestServiceQuotaIncreaseRequest> {
        /**
         * <p>
         * Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the
         * <a>ListServices</a> operation.
         * </p>
         * 
         * @param serviceCode
         *        Specifies the service identifier. To find the service code value for an Amazon Web Services service,
         *        use the <a>ListServices</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * Specifies the quota identifier. To find the quota code for a specific quota, use the <a>ListServiceQuotas</a>
         * operation, and look for the <code>QuotaCode</code> response in the output for the quota you want.
         * </p>
         * 
         * @param quotaCode
         *        Specifies the quota identifier. To find the quota code for a specific quota, use the
         *        <a>ListServiceQuotas</a> operation, and look for the <code>QuotaCode</code> response in the output for
         *        the quota you want.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaCode(String quotaCode);

        /**
         * <p>
         * Specifies the new, increased value for the quota.
         * </p>
         * 
         * @param desiredValue
         *        Specifies the new, increased value for the quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredValue(Double desiredValue);

        /**
         * <p>
         * Specifies the Amazon Web Services account or resource to which the quota applies. The value in this field
         * depends on the context scope associated with the specified service quota.
         * </p>
         * 
         * @param contextId
         *        Specifies the Amazon Web Services account or resource to which the quota applies. The value in this
         *        field depends on the context scope associated with the specified service quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextId(String contextId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceQuotasRequest.BuilderImpl implements Builder {
        private String serviceCode;

        private String quotaCode;

        private Double desiredValue;

        private String contextId;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestServiceQuotaIncreaseRequest model) {
            super(model);
            serviceCode(model.serviceCode);
            quotaCode(model.quotaCode);
            desiredValue(model.desiredValue);
            contextId(model.contextId);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getQuotaCode() {
            return quotaCode;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final Double getDesiredValue() {
            return desiredValue;
        }

        public final void setDesiredValue(Double desiredValue) {
            this.desiredValue = desiredValue;
        }

        @Override
        public final Builder desiredValue(Double desiredValue) {
            this.desiredValue = desiredValue;
            return this;
        }

        public final String getContextId() {
            return contextId;
        }

        public final void setContextId(String contextId) {
            this.contextId = contextId;
        }

        @Override
        public final Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RequestServiceQuotaIncreaseRequest build() {
            return new RequestServiceQuotaIncreaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
