/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceQuotaIncreaseRequestsInTemplateResponse extends ServiceQuotasResponse
        implements
        ToCopyableBuilder<ListServiceQuotaIncreaseRequestsInTemplateResponse.Builder, ListServiceQuotaIncreaseRequestsInTemplateResponse> {
    private static final SdkField<List<ServiceQuotaIncreaseRequestInTemplate>> SERVICE_QUOTA_INCREASE_REQUEST_IN_TEMPLATE_LIST_FIELD = SdkField
            .<List<ServiceQuotaIncreaseRequestInTemplate>> builder(MarshallingType.LIST)
            .memberName("ServiceQuotaIncreaseRequestInTemplateList")
            .getter(getter(ListServiceQuotaIncreaseRequestsInTemplateResponse::serviceQuotaIncreaseRequestInTemplateList))
            .setter(setter(Builder::serviceQuotaIncreaseRequestInTemplateList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ServiceQuotaIncreaseRequestInTemplateList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceQuotaIncreaseRequestInTemplate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceQuotaIncreaseRequestInTemplate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListServiceQuotaIncreaseRequestsInTemplateResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SERVICE_QUOTA_INCREASE_REQUEST_IN_TEMPLATE_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ServiceQuotaIncreaseRequestInTemplate> serviceQuotaIncreaseRequestInTemplateList;

    private final String nextToken;

    private ListServiceQuotaIncreaseRequestsInTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.serviceQuotaIncreaseRequestInTemplateList = builder.serviceQuotaIncreaseRequestInTemplateList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * ServiceQuotaIncreaseRequestInTemplateList property. This DOES NOT check that the value is non-empty (for which,
     * you should check the {@code isEmpty()} method on the property). This is useful because the SDK will never return
     * a null collection or map, but you may need to differentiate between the service returning nothing (or null) and
     * the service returning an empty collection or map. For requests, this returns true if a value for the property was
     * specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasServiceQuotaIncreaseRequestInTemplateList() {
        return serviceQuotaIncreaseRequestInTemplateList != null
                && !(serviceQuotaIncreaseRequestInTemplateList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the quota increase requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasServiceQuotaIncreaseRequestInTemplateList} method.
     * </p>
     * 
     * @return Information about the quota increase requests.
     */
    public final List<ServiceQuotaIncreaseRequestInTemplate> serviceQuotaIncreaseRequestInTemplateList() {
        return serviceQuotaIncreaseRequestInTemplateList;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * </p>
     * 
     * @return If present, indicates that more output is available than is included in the current response. Use this
     *         value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *         next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *         back as <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasServiceQuotaIncreaseRequestInTemplateList() ? serviceQuotaIncreaseRequestInTemplateList()
                        : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceQuotaIncreaseRequestsInTemplateResponse)) {
            return false;
        }
        ListServiceQuotaIncreaseRequestsInTemplateResponse other = (ListServiceQuotaIncreaseRequestsInTemplateResponse) obj;
        return hasServiceQuotaIncreaseRequestInTemplateList() == other.hasServiceQuotaIncreaseRequestInTemplateList()
                && Objects.equals(serviceQuotaIncreaseRequestInTemplateList(), other.serviceQuotaIncreaseRequestInTemplateList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListServiceQuotaIncreaseRequestsInTemplateResponse")
                .add("ServiceQuotaIncreaseRequestInTemplateList",
                        hasServiceQuotaIncreaseRequestInTemplateList() ? serviceQuotaIncreaseRequestInTemplateList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceQuotaIncreaseRequestInTemplateList":
            return Optional.ofNullable(clazz.cast(serviceQuotaIncreaseRequestInTemplateList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceQuotaIncreaseRequestInTemplateList", SERVICE_QUOTA_INCREASE_REQUEST_IN_TEMPLATE_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceQuotaIncreaseRequestsInTemplateResponse, T> g) {
        return obj -> g.apply((ListServiceQuotaIncreaseRequestsInTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceQuotasResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServiceQuotaIncreaseRequestsInTemplateResponse> {
        /**
         * <p>
         * Information about the quota increase requests.
         * </p>
         * 
         * @param serviceQuotaIncreaseRequestInTemplateList
         *        Information about the quota increase requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceQuotaIncreaseRequestInTemplateList(
                Collection<ServiceQuotaIncreaseRequestInTemplate> serviceQuotaIncreaseRequestInTemplateList);

        /**
         * <p>
         * Information about the quota increase requests.
         * </p>
         * 
         * @param serviceQuotaIncreaseRequestInTemplateList
         *        Information about the quota increase requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceQuotaIncreaseRequestInTemplateList(
                ServiceQuotaIncreaseRequestInTemplate... serviceQuotaIncreaseRequestInTemplateList);

        /**
         * <p>
         * Information about the quota increase requests.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #serviceQuotaIncreaseRequestInTemplateList(List<ServiceQuotaIncreaseRequestInTemplate>)}.
         * 
         * @param serviceQuotaIncreaseRequestInTemplateList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.servicequotas.model.ServiceQuotaIncreaseRequestInTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceQuotaIncreaseRequestInTemplateList(java.util.Collection<ServiceQuotaIncreaseRequestInTemplate>)
         */
        Builder serviceQuotaIncreaseRequestInTemplateList(
                Consumer<ServiceQuotaIncreaseRequestInTemplate.Builder>... serviceQuotaIncreaseRequestInTemplateList);

        /**
         * <p>
         * If present, indicates that more output is available than is included in the current response. Use this value
         * in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of
         * the output. You should repeat this until the <code>NextToken</code> response element comes back as
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If present, indicates that more output is available than is included in the current response. Use this
         *        value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         *        next part of the output. You should repeat this until the <code>NextToken</code> response element
         *        comes back as <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ServiceQuotasResponse.BuilderImpl implements Builder {
        private List<ServiceQuotaIncreaseRequestInTemplate> serviceQuotaIncreaseRequestInTemplateList = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceQuotaIncreaseRequestsInTemplateResponse model) {
            super(model);
            serviceQuotaIncreaseRequestInTemplateList(model.serviceQuotaIncreaseRequestInTemplateList);
            nextToken(model.nextToken);
        }

        public final List<ServiceQuotaIncreaseRequestInTemplate.Builder> getServiceQuotaIncreaseRequestInTemplateList() {
            List<ServiceQuotaIncreaseRequestInTemplate.Builder> result = ServiceQuotaIncreaseRequestInTemplateListCopier
                    .copyToBuilder(this.serviceQuotaIncreaseRequestInTemplateList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceQuotaIncreaseRequestInTemplateList(
                Collection<ServiceQuotaIncreaseRequestInTemplate.BuilderImpl> serviceQuotaIncreaseRequestInTemplateList) {
            this.serviceQuotaIncreaseRequestInTemplateList = ServiceQuotaIncreaseRequestInTemplateListCopier
                    .copyFromBuilder(serviceQuotaIncreaseRequestInTemplateList);
        }

        @Override
        public final Builder serviceQuotaIncreaseRequestInTemplateList(
                Collection<ServiceQuotaIncreaseRequestInTemplate> serviceQuotaIncreaseRequestInTemplateList) {
            this.serviceQuotaIncreaseRequestInTemplateList = ServiceQuotaIncreaseRequestInTemplateListCopier
                    .copy(serviceQuotaIncreaseRequestInTemplateList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceQuotaIncreaseRequestInTemplateList(
                ServiceQuotaIncreaseRequestInTemplate... serviceQuotaIncreaseRequestInTemplateList) {
            serviceQuotaIncreaseRequestInTemplateList(Arrays.asList(serviceQuotaIncreaseRequestInTemplateList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceQuotaIncreaseRequestInTemplateList(
                Consumer<ServiceQuotaIncreaseRequestInTemplate.Builder>... serviceQuotaIncreaseRequestInTemplateList) {
            serviceQuotaIncreaseRequestInTemplateList(Stream.of(serviceQuotaIncreaseRequestInTemplateList)
                    .map(c -> ServiceQuotaIncreaseRequestInTemplate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListServiceQuotaIncreaseRequestsInTemplateResponse build() {
            return new ListServiceQuotaIncreaseRequestsInTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
