/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasAsyncClient;
import software.amazon.awssdk.services.servicequotas.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuota;

public class ListServiceQuotasPublisher
implements SdkPublisher<ListServiceQuotasResponse> {
    private final ServiceQuotasAsyncClient client;
    private final ListServiceQuotasRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceQuotasPublisher(ServiceQuotasAsyncClient client, ListServiceQuotasRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceQuotasPublisher(ServiceQuotasAsyncClient client, ListServiceQuotasRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceQuotasResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceQuotasResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceQuota> quotas() {
        Function<ListServiceQuotasResponse, Iterator> getIterator = response -> {
            if (response != null && response.quotas() != null) {
                return response.quotas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceQuotasResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceQuotasResponseFetcher
    implements AsyncPageFetcher<ListServiceQuotasResponse> {
        private ListServiceQuotasResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceQuotasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceQuotasResponse> nextPage(ListServiceQuotasResponse previousPage) {
            if (previousPage == null) {
                return ListServiceQuotasPublisher.this.client.listServiceQuotas(ListServiceQuotasPublisher.this.firstRequest);
            }
            return ListServiceQuotasPublisher.this.client.listServiceQuotas((ListServiceQuotasRequest)((Object)ListServiceQuotasPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

