/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicequotas.model.AppliedLevelEnum;
import software.amazon.awssdk.services.servicequotas.model.RequestStatus;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRequestedServiceQuotaChangeHistoryByQuotaRequest
extends ServiceQuotasRequest
implements ToCopyableBuilder<Builder, ListRequestedServiceQuotaChangeHistoryByQuotaRequest> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceCode").getter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.getter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest::serviceCode)).setter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()}).build();
    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuotaCode").getter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.getter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest::quotaCode)).setter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.setter(Builder::quotaCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaCode").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.getter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest::statusAsString)).setter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.getter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest::nextToken)).setter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.getter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest::maxResults)).setter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> QUOTA_REQUESTED_AT_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuotaRequestedAtLevel").getter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.getter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest::quotaRequestedAtLevelAsString)).setter(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.setter(Builder::quotaRequestedAtLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaRequestedAtLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD, QUOTA_CODE_FIELD, STATUS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, QUOTA_REQUESTED_AT_LEVEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRequestedServiceQuotaChangeHistoryByQuotaRequest.memberNameToFieldInitializer();
    private final String serviceCode;
    private final String quotaCode;
    private final String status;
    private final String nextToken;
    private final Integer maxResults;
    private final String quotaRequestedAtLevel;

    private ListRequestedServiceQuotaChangeHistoryByQuotaRequest(BuilderImpl builder) {
        super(builder);
        this.serviceCode = builder.serviceCode;
        this.quotaCode = builder.quotaCode;
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.quotaRequestedAtLevel = builder.quotaRequestedAtLevel;
    }

    public final String serviceCode() {
        return this.serviceCode;
    }

    public final String quotaCode() {
        return this.quotaCode;
    }

    public final RequestStatus status() {
        return RequestStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final AppliedLevelEnum quotaRequestedAtLevel() {
        return AppliedLevelEnum.fromValue(this.quotaRequestedAtLevel);
    }

    public final String quotaRequestedAtLevelAsString() {
        return this.quotaRequestedAtLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaRequestedAtLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRequestedServiceQuotaChangeHistoryByQuotaRequest)) {
            return false;
        }
        ListRequestedServiceQuotaChangeHistoryByQuotaRequest other = (ListRequestedServiceQuotaChangeHistoryByQuotaRequest)((Object)obj);
        return Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.quotaCode(), other.quotaCode()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.quotaRequestedAtLevelAsString(), other.quotaRequestedAtLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListRequestedServiceQuotaChangeHistoryByQuotaRequest").add("ServiceCode", (Object)this.serviceCode()).add("QuotaCode", (Object)this.quotaCode()).add("Status", (Object)this.statusAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("QuotaRequestedAtLevel", (Object)this.quotaRequestedAtLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "QuotaCode": {
                return Optional.ofNullable(clazz.cast(this.quotaCode()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "QuotaRequestedAtLevel": {
                return Optional.ofNullable(clazz.cast(this.quotaRequestedAtLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceCode", SERVICE_CODE_FIELD);
        map.put("QuotaCode", QUOTA_CODE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("QuotaRequestedAtLevel", QUOTA_REQUESTED_AT_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRequestedServiceQuotaChangeHistoryByQuotaRequest, T> g) {
        return obj -> g.apply((ListRequestedServiceQuotaChangeHistoryByQuotaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceQuotasRequest.BuilderImpl
    implements Builder {
        private String serviceCode;
        private String quotaCode;
        private String status;
        private String nextToken;
        private Integer maxResults;
        private String quotaRequestedAtLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRequestedServiceQuotaChangeHistoryByQuotaRequest model) {
            super(model);
            this.serviceCode(model.serviceCode);
            this.quotaCode(model.quotaCode);
            this.status(model.status);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.quotaRequestedAtLevel(model.quotaRequestedAtLevel);
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getQuotaCode() {
            return this.quotaCode;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getQuotaRequestedAtLevel() {
            return this.quotaRequestedAtLevel;
        }

        public final void setQuotaRequestedAtLevel(String quotaRequestedAtLevel) {
            this.quotaRequestedAtLevel = quotaRequestedAtLevel;
        }

        @Override
        public final Builder quotaRequestedAtLevel(String quotaRequestedAtLevel) {
            this.quotaRequestedAtLevel = quotaRequestedAtLevel;
            return this;
        }

        @Override
        public final Builder quotaRequestedAtLevel(AppliedLevelEnum quotaRequestedAtLevel) {
            this.quotaRequestedAtLevel(quotaRequestedAtLevel == null ? null : quotaRequestedAtLevel.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRequestedServiceQuotaChangeHistoryByQuotaRequest build() {
            return new ListRequestedServiceQuotaChangeHistoryByQuotaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServiceQuotasRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRequestedServiceQuotaChangeHistoryByQuotaRequest> {
        public Builder serviceCode(String var1);

        public Builder quotaCode(String var1);

        public Builder status(String var1);

        public Builder status(RequestStatus var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder quotaRequestedAtLevel(String var1);

        public Builder quotaRequestedAtLevel(AppliedLevelEnum var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

