/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasAsyncClient;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasServiceClientConfiguration;
import software.amazon.awssdk.services.servicequotas.internal.ServiceQuotasServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.servicequotas.model.AccessDeniedException;
import software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.AwsServiceAccessNotEnabledException;
import software.amazon.awssdk.services.servicequotas.model.CreateSupportCaseRequest;
import software.amazon.awssdk.services.servicequotas.model.CreateSupportCaseResponse;
import software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.DependencyAccessDeniedException;
import software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeRequest;
import software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeResponse;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.IllegalArgumentException;
import software.amazon.awssdk.services.servicequotas.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.servicequotas.model.InvalidResourceStateException;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServicesRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServicesResponse;
import software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.servicequotas.model.NoAvailableOrganizationException;
import software.amazon.awssdk.services.servicequotas.model.NoSuchResourceException;
import software.amazon.awssdk.services.servicequotas.model.OrganizationNotInAllFeaturesModeException;
import software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.QuotaExceededException;
import software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest;
import software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseResponse;
import software.amazon.awssdk.services.servicequotas.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.servicequotas.model.ServiceException;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotaTemplateNotInUseException;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasException;
import software.amazon.awssdk.services.servicequotas.model.TagPolicyViolationException;
import software.amazon.awssdk.services.servicequotas.model.TagResourceRequest;
import software.amazon.awssdk.services.servicequotas.model.TagResourceResponse;
import software.amazon.awssdk.services.servicequotas.model.TemplatesNotAvailableInRegionException;
import software.amazon.awssdk.services.servicequotas.model.TooManyRequestsException;
import software.amazon.awssdk.services.servicequotas.model.TooManyTagsException;
import software.amazon.awssdk.services.servicequotas.model.UntagResourceRequest;
import software.amazon.awssdk.services.servicequotas.model.UntagResourceResponse;
import software.amazon.awssdk.services.servicequotas.transform.AssociateServiceQuotaTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.CreateSupportCaseRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.DeleteServiceQuotaIncreaseRequestFromTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.DisassociateServiceQuotaTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetAssociationForServiceQuotaTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetAwsDefaultServiceQuotaRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetRequestedServiceQuotaChangeRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetServiceQuotaIncreaseRequestFromTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetServiceQuotaRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListAwsDefaultServiceQuotasRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListRequestedServiceQuotaChangeHistoryByQuotaRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListRequestedServiceQuotaChangeHistoryRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListServiceQuotaIncreaseRequestsInTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListServiceQuotasRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListServicesRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.PutServiceQuotaIncreaseRequestIntoTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.RequestServiceQuotaIncreaseRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultServiceQuotasAsyncClient
implements ServiceQuotasAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultServiceQuotasAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultServiceQuotasAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Service_Quotas#2.32.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AssociateServiceQuotaTemplateResponse> associateServiceQuotaTemplate(AssociateServiceQuotaTemplateRequest associateServiceQuotaTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateServiceQuotaTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, associateServiceQuotaTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateServiceQuotaTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateServiceQuotaTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateServiceQuotaTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AssociateServiceQuotaTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)associateServiceQuotaTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$associateServiceQuotaTemplate$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$associateServiceQuotaTemplate$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSupportCaseResponse> createSupportCase(CreateSupportCaseRequest createSupportCaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSupportCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, createSupportCaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSupportCase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSupportCaseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSupportCase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSupportCaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSupportCaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$createSupportCase$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$createSupportCase$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteServiceQuotaIncreaseRequestFromTemplateResponse> deleteServiceQuotaIncreaseRequestFromTemplate(DeleteServiceQuotaIncreaseRequestFromTemplateRequest deleteServiceQuotaIncreaseRequestFromTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteServiceQuotaIncreaseRequestFromTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, deleteServiceQuotaIncreaseRequestFromTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteServiceQuotaIncreaseRequestFromTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceQuotaIncreaseRequestFromTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServiceQuotaIncreaseRequestFromTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteServiceQuotaIncreaseRequestFromTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteServiceQuotaIncreaseRequestFromTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$deleteServiceQuotaIncreaseRequestFromTemplate$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$deleteServiceQuotaIncreaseRequestFromTemplate$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisassociateServiceQuotaTemplateResponse> disassociateServiceQuotaTemplate(DisassociateServiceQuotaTemplateRequest disassociateServiceQuotaTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateServiceQuotaTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, disassociateServiceQuotaTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateServiceQuotaTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateServiceQuotaTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateServiceQuotaTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DisassociateServiceQuotaTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disassociateServiceQuotaTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$disassociateServiceQuotaTemplate$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$disassociateServiceQuotaTemplate$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAwsDefaultServiceQuotaResponse> getAWSDefaultServiceQuota(GetAwsDefaultServiceQuotaRequest getAwsDefaultServiceQuotaRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAwsDefaultServiceQuotaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, getAwsDefaultServiceQuotaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAWSDefaultServiceQuota");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAwsDefaultServiceQuotaResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAWSDefaultServiceQuota").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAwsDefaultServiceQuotaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAwsDefaultServiceQuotaRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$getAWSDefaultServiceQuota$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$getAWSDefaultServiceQuota$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAssociationForServiceQuotaTemplateResponse> getAssociationForServiceQuotaTemplate(GetAssociationForServiceQuotaTemplateRequest getAssociationForServiceQuotaTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAssociationForServiceQuotaTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, getAssociationForServiceQuotaTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAssociationForServiceQuotaTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAssociationForServiceQuotaTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAssociationForServiceQuotaTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAssociationForServiceQuotaTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAssociationForServiceQuotaTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$getAssociationForServiceQuotaTemplate$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$getAssociationForServiceQuotaTemplate$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRequestedServiceQuotaChangeResponse> getRequestedServiceQuotaChange(GetRequestedServiceQuotaChangeRequest getRequestedServiceQuotaChangeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRequestedServiceQuotaChangeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, getRequestedServiceQuotaChangeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRequestedServiceQuotaChange");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRequestedServiceQuotaChangeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRequestedServiceQuotaChange").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRequestedServiceQuotaChangeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRequestedServiceQuotaChangeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$getRequestedServiceQuotaChange$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$getRequestedServiceQuotaChange$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetServiceQuotaResponse> getServiceQuota(GetServiceQuotaRequest getServiceQuotaRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getServiceQuotaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, getServiceQuotaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServiceQuota");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceQuotaResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServiceQuota").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetServiceQuotaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getServiceQuotaRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$getServiceQuota$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$getServiceQuota$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetServiceQuotaIncreaseRequestFromTemplateResponse> getServiceQuotaIncreaseRequestFromTemplate(GetServiceQuotaIncreaseRequestFromTemplateRequest getServiceQuotaIncreaseRequestFromTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getServiceQuotaIncreaseRequestFromTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, getServiceQuotaIncreaseRequestFromTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServiceQuotaIncreaseRequestFromTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceQuotaIncreaseRequestFromTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServiceQuotaIncreaseRequestFromTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetServiceQuotaIncreaseRequestFromTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getServiceQuotaIncreaseRequestFromTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$getServiceQuotaIncreaseRequestFromTemplate$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$getServiceQuotaIncreaseRequestFromTemplate$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAwsDefaultServiceQuotasResponse> listAWSDefaultServiceQuotas(ListAwsDefaultServiceQuotasRequest listAwsDefaultServiceQuotasRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAwsDefaultServiceQuotasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, listAwsDefaultServiceQuotasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAWSDefaultServiceQuotas");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAwsDefaultServiceQuotasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAWSDefaultServiceQuotas").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListAwsDefaultServiceQuotasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAwsDefaultServiceQuotasRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$listAWSDefaultServiceQuotas$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$listAWSDefaultServiceQuotas$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRequestedServiceQuotaChangeHistoryResponse> listRequestedServiceQuotaChangeHistory(ListRequestedServiceQuotaChangeHistoryRequest listRequestedServiceQuotaChangeHistoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRequestedServiceQuotaChangeHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, listRequestedServiceQuotaChangeHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRequestedServiceQuotaChangeHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRequestedServiceQuotaChangeHistoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRequestedServiceQuotaChangeHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRequestedServiceQuotaChangeHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRequestedServiceQuotaChangeHistoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$listRequestedServiceQuotaChangeHistory$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$listRequestedServiceQuotaChangeHistory$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRequestedServiceQuotaChangeHistoryByQuotaResponse> listRequestedServiceQuotaChangeHistoryByQuota(ListRequestedServiceQuotaChangeHistoryByQuotaRequest listRequestedServiceQuotaChangeHistoryByQuotaRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRequestedServiceQuotaChangeHistoryByQuotaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, listRequestedServiceQuotaChangeHistoryByQuotaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRequestedServiceQuotaChangeHistoryByQuota");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRequestedServiceQuotaChangeHistoryByQuotaResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRequestedServiceQuotaChangeHistoryByQuota").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRequestedServiceQuotaChangeHistoryByQuotaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRequestedServiceQuotaChangeHistoryByQuotaRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$listRequestedServiceQuotaChangeHistoryByQuota$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$listRequestedServiceQuotaChangeHistoryByQuota$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListServiceQuotaIncreaseRequestsInTemplateResponse> listServiceQuotaIncreaseRequestsInTemplate(ListServiceQuotaIncreaseRequestsInTemplateRequest listServiceQuotaIncreaseRequestsInTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServiceQuotaIncreaseRequestsInTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, listServiceQuotaIncreaseRequestsInTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceQuotaIncreaseRequestsInTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceQuotaIncreaseRequestsInTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceQuotaIncreaseRequestsInTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListServiceQuotaIncreaseRequestsInTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listServiceQuotaIncreaseRequestsInTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$listServiceQuotaIncreaseRequestsInTemplate$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$listServiceQuotaIncreaseRequestsInTemplate$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListServiceQuotasResponse> listServiceQuotas(ListServiceQuotasRequest listServiceQuotasRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServiceQuotasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, listServiceQuotasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceQuotas");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceQuotasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceQuotas").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListServiceQuotasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listServiceQuotasRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$listServiceQuotas$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$listServiceQuotas$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListServicesResponse> listServices(ListServicesRequest listServicesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, listServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServicesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listServicesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$listServices$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$listServices$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$listTagsForResource$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$listTagsForResource$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutServiceQuotaIncreaseRequestIntoTemplateResponse> putServiceQuotaIncreaseRequestIntoTemplate(PutServiceQuotaIncreaseRequestIntoTemplateRequest putServiceQuotaIncreaseRequestIntoTemplateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putServiceQuotaIncreaseRequestIntoTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, putServiceQuotaIncreaseRequestIntoTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutServiceQuotaIncreaseRequestIntoTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutServiceQuotaIncreaseRequestIntoTemplateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutServiceQuotaIncreaseRequestIntoTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutServiceQuotaIncreaseRequestIntoTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putServiceQuotaIncreaseRequestIntoTemplateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$putServiceQuotaIncreaseRequestIntoTemplate$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$putServiceQuotaIncreaseRequestIntoTemplate$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RequestServiceQuotaIncreaseResponse> requestServiceQuotaIncrease(RequestServiceQuotaIncreaseRequest requestServiceQuotaIncreaseRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)requestServiceQuotaIncreaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, requestServiceQuotaIncreaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RequestServiceQuotaIncrease");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RequestServiceQuotaIncreaseResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RequestServiceQuotaIncrease").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RequestServiceQuotaIncreaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)requestServiceQuotaIncreaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$requestServiceQuotaIncrease$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$requestServiceQuotaIncrease$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$tagResource$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$tagResource$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidResourceStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                    }
                    case "IllegalArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                    }
                    case "ServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                    }
                    case "OrganizationNotInAllFeaturesModeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                    }
                    case "AWSServiceAccessNotEnabledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                    }
                    case "DependencyAccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                    }
                    case "NoSuchResourceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                    }
                    case "QuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                    }
                    case "ResourceAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                    }
                    case "NoAvailableOrganizationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                    }
                    case "TemplatesNotAvailableInRegionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                    }
                    case "InvalidPaginationTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "TagPolicyViolationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                    }
                    case "ServiceQuotaTemplateNotInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultServiceQuotasAsyncClient.lambda$untagResource$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasAsyncClient.lambda$untagResource$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final ServiceQuotasServiceClientConfiguration serviceClientConfiguration() {
        return new ServiceQuotasServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "servicequotas";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ServiceQuotasException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ServiceQuotasServiceClientConfigurationBuilder serviceConfigBuilder = new ServiceQuotasServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$untagResource$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$78(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$74(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$requestServiceQuotaIncrease$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$requestServiceQuotaIncrease$70(List metricPublishers, MetricCollector apiCallMetricCollector, RequestServiceQuotaIncreaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putServiceQuotaIncreaseRequestIntoTemplate$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putServiceQuotaIncreaseRequestIntoTemplate$66(List metricPublishers, MetricCollector apiCallMetricCollector, PutServiceQuotaIncreaseRequestIntoTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$62(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listServices$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServices$58(List metricPublishers, MetricCollector apiCallMetricCollector, ListServicesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listServiceQuotas$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServiceQuotas$54(List metricPublishers, MetricCollector apiCallMetricCollector, ListServiceQuotasResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listServiceQuotaIncreaseRequestsInTemplate$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServiceQuotaIncreaseRequestsInTemplate$50(List metricPublishers, MetricCollector apiCallMetricCollector, ListServiceQuotaIncreaseRequestsInTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRequestedServiceQuotaChangeHistoryByQuota$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRequestedServiceQuotaChangeHistoryByQuota$46(List metricPublishers, MetricCollector apiCallMetricCollector, ListRequestedServiceQuotaChangeHistoryByQuotaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRequestedServiceQuotaChangeHistory$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRequestedServiceQuotaChangeHistory$42(List metricPublishers, MetricCollector apiCallMetricCollector, ListRequestedServiceQuotaChangeHistoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAWSDefaultServiceQuotas$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAWSDefaultServiceQuotas$38(List metricPublishers, MetricCollector apiCallMetricCollector, ListAwsDefaultServiceQuotasResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getServiceQuotaIncreaseRequestFromTemplate$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServiceQuotaIncreaseRequestFromTemplate$34(List metricPublishers, MetricCollector apiCallMetricCollector, GetServiceQuotaIncreaseRequestFromTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getServiceQuota$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServiceQuota$30(List metricPublishers, MetricCollector apiCallMetricCollector, GetServiceQuotaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRequestedServiceQuotaChange$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRequestedServiceQuotaChange$26(List metricPublishers, MetricCollector apiCallMetricCollector, GetRequestedServiceQuotaChangeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAssociationForServiceQuotaTemplate$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAssociationForServiceQuotaTemplate$22(List metricPublishers, MetricCollector apiCallMetricCollector, GetAssociationForServiceQuotaTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAWSDefaultServiceQuota$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAWSDefaultServiceQuota$18(List metricPublishers, MetricCollector apiCallMetricCollector, GetAwsDefaultServiceQuotaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disassociateServiceQuotaTemplate$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateServiceQuotaTemplate$14(List metricPublishers, MetricCollector apiCallMetricCollector, DisassociateServiceQuotaTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteServiceQuotaIncreaseRequestFromTemplate$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteServiceQuotaIncreaseRequestFromTemplate$10(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteServiceQuotaIncreaseRequestFromTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSupportCase$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSupportCase$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSupportCaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$associateServiceQuotaTemplate$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateServiceQuotaTemplate$2(List metricPublishers, MetricCollector apiCallMetricCollector, AssociateServiceQuotaTemplateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

