/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes the context for a resource-level quota. For resource-level quotas, such as
 * <code>Instances per OpenSearch Service Domain</code>, you can apply the quota value at the resource-level for each
 * OpenSearch Service Domain in your Amazon Web Services account. Together the attributes of this structure help you
 * understand how the quota is implemented by Amazon Web Services and how you can manage it. For quotas such as
 * <code>Amazon OpenSearch Service Domains</code> which can be managed at the account-level for each Amazon Web Services
 * Region, the <code>QuotaContext</code> field is absent. See the attribute descriptions below to further understand how
 * to use them.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuotaContextInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<QuotaContextInfo.Builder, QuotaContextInfo> {
    private static final SdkField<String> CONTEXT_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContextScope").getter(getter(QuotaContextInfo::contextScopeAsString))
            .setter(setter(Builder::contextScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextScope").build()).build();

    private static final SdkField<String> CONTEXT_SCOPE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContextScopeType").getter(getter(QuotaContextInfo::contextScopeType))
            .setter(setter(Builder::contextScopeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextScopeType").build()).build();

    private static final SdkField<String> CONTEXT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContextId").getter(getter(QuotaContextInfo::contextId)).setter(setter(Builder::contextId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_SCOPE_FIELD,
            CONTEXT_SCOPE_TYPE_FIELD, CONTEXT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String contextScope;

    private final String contextScopeType;

    private final String contextId;

    private QuotaContextInfo(BuilderImpl builder) {
        this.contextScope = builder.contextScope;
        this.contextScopeType = builder.contextScopeType;
        this.contextId = builder.contextId;
    }

    /**
     * <p>
     * Specifies the scope to which the quota value is applied. If the scope is <code>RESOURCE</code>, the quota value
     * is applied to each resource in the Amazon Web Services account. If the scope is <code>ACCOUNT</code>, the quota
     * value is applied to the Amazon Web Services account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contextScope} will
     * return {@link QuotaContextScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contextScopeAsString}.
     * </p>
     * 
     * @return Specifies the scope to which the quota value is applied. If the scope is <code>RESOURCE</code>, the quota
     *         value is applied to each resource in the Amazon Web Services account. If the scope is
     *         <code>ACCOUNT</code>, the quota value is applied to the Amazon Web Services account.
     * @see QuotaContextScope
     */
    public final QuotaContextScope contextScope() {
        return QuotaContextScope.fromValue(contextScope);
    }

    /**
     * <p>
     * Specifies the scope to which the quota value is applied. If the scope is <code>RESOURCE</code>, the quota value
     * is applied to each resource in the Amazon Web Services account. If the scope is <code>ACCOUNT</code>, the quota
     * value is applied to the Amazon Web Services account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contextScope} will
     * return {@link QuotaContextScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contextScopeAsString}.
     * </p>
     * 
     * @return Specifies the scope to which the quota value is applied. If the scope is <code>RESOURCE</code>, the quota
     *         value is applied to each resource in the Amazon Web Services account. If the scope is
     *         <code>ACCOUNT</code>, the quota value is applied to the Amazon Web Services account.
     * @see QuotaContextScope
     */
    public final String contextScopeAsString() {
        return contextScope;
    }

    /**
     * <p>
     * Specifies the resource type to which the quota can be applied.
     * </p>
     * 
     * @return Specifies the resource type to which the quota can be applied.
     */
    public final String contextScopeType() {
        return contextScopeType;
    }

    /**
     * <p>
     * Specifies the resource, or resources, to which the quota applies. The value for this field is either an Amazon
     * Resource Name (ARN) or *. If the value is an ARN, the quota value applies to that resource. If the value is *,
     * then the quota value applies to all resources listed in the <code>ContextScopeType</code> field. The quota value
     * applies to all resources for which you haven’t previously applied a quota value, and any new resources you create
     * in your Amazon Web Services account.
     * </p>
     * 
     * @return Specifies the resource, or resources, to which the quota applies. The value for this field is either an
     *         Amazon Resource Name (ARN) or *. If the value is an ARN, the quota value applies to that resource. If the
     *         value is *, then the quota value applies to all resources listed in the <code>ContextScopeType</code>
     *         field. The quota value applies to all resources for which you haven’t previously applied a quota value,
     *         and any new resources you create in your Amazon Web Services account.
     */
    public final String contextId() {
        return contextId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contextScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contextScopeType());
        hashCode = 31 * hashCode + Objects.hashCode(contextId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuotaContextInfo)) {
            return false;
        }
        QuotaContextInfo other = (QuotaContextInfo) obj;
        return Objects.equals(contextScopeAsString(), other.contextScopeAsString())
                && Objects.equals(contextScopeType(), other.contextScopeType()) && Objects.equals(contextId(), other.contextId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuotaContextInfo").add("ContextScope", contextScopeAsString())
                .add("ContextScopeType", contextScopeType()).add("ContextId", contextId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContextScope":
            return Optional.ofNullable(clazz.cast(contextScopeAsString()));
        case "ContextScopeType":
            return Optional.ofNullable(clazz.cast(contextScopeType()));
        case "ContextId":
            return Optional.ofNullable(clazz.cast(contextId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContextScope", CONTEXT_SCOPE_FIELD);
        map.put("ContextScopeType", CONTEXT_SCOPE_TYPE_FIELD);
        map.put("ContextId", CONTEXT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QuotaContextInfo, T> g) {
        return obj -> g.apply((QuotaContextInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuotaContextInfo> {
        /**
         * <p>
         * Specifies the scope to which the quota value is applied. If the scope is <code>RESOURCE</code>, the quota
         * value is applied to each resource in the Amazon Web Services account. If the scope is <code>ACCOUNT</code>,
         * the quota value is applied to the Amazon Web Services account.
         * </p>
         * 
         * @param contextScope
         *        Specifies the scope to which the quota value is applied. If the scope is <code>RESOURCE</code>, the
         *        quota value is applied to each resource in the Amazon Web Services account. If the scope is
         *        <code>ACCOUNT</code>, the quota value is applied to the Amazon Web Services account.
         * @see QuotaContextScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuotaContextScope
         */
        Builder contextScope(String contextScope);

        /**
         * <p>
         * Specifies the scope to which the quota value is applied. If the scope is <code>RESOURCE</code>, the quota
         * value is applied to each resource in the Amazon Web Services account. If the scope is <code>ACCOUNT</code>,
         * the quota value is applied to the Amazon Web Services account.
         * </p>
         * 
         * @param contextScope
         *        Specifies the scope to which the quota value is applied. If the scope is <code>RESOURCE</code>, the
         *        quota value is applied to each resource in the Amazon Web Services account. If the scope is
         *        <code>ACCOUNT</code>, the quota value is applied to the Amazon Web Services account.
         * @see QuotaContextScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuotaContextScope
         */
        Builder contextScope(QuotaContextScope contextScope);

        /**
         * <p>
         * Specifies the resource type to which the quota can be applied.
         * </p>
         * 
         * @param contextScopeType
         *        Specifies the resource type to which the quota can be applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextScopeType(String contextScopeType);

        /**
         * <p>
         * Specifies the resource, or resources, to which the quota applies. The value for this field is either an
         * Amazon Resource Name (ARN) or *. If the value is an ARN, the quota value applies to that resource. If the
         * value is *, then the quota value applies to all resources listed in the <code>ContextScopeType</code> field.
         * The quota value applies to all resources for which you haven’t previously applied a quota value, and any new
         * resources you create in your Amazon Web Services account.
         * </p>
         * 
         * @param contextId
         *        Specifies the resource, or resources, to which the quota applies. The value for this field is either
         *        an Amazon Resource Name (ARN) or *. If the value is an ARN, the quota value applies to that resource.
         *        If the value is *, then the quota value applies to all resources listed in the
         *        <code>ContextScopeType</code> field. The quota value applies to all resources for which you haven’t
         *        previously applied a quota value, and any new resources you create in your Amazon Web Services
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextId(String contextId);
    }

    static final class BuilderImpl implements Builder {
        private String contextScope;

        private String contextScopeType;

        private String contextId;

        private BuilderImpl() {
        }

        private BuilderImpl(QuotaContextInfo model) {
            contextScope(model.contextScope);
            contextScopeType(model.contextScopeType);
            contextId(model.contextId);
        }

        public final String getContextScope() {
            return contextScope;
        }

        public final void setContextScope(String contextScope) {
            this.contextScope = contextScope;
        }

        @Override
        public final Builder contextScope(String contextScope) {
            this.contextScope = contextScope;
            return this;
        }

        @Override
        public final Builder contextScope(QuotaContextScope contextScope) {
            this.contextScope(contextScope == null ? null : contextScope.toString());
            return this;
        }

        public final String getContextScopeType() {
            return contextScopeType;
        }

        public final void setContextScopeType(String contextScopeType) {
            this.contextScopeType = contextScopeType;
        }

        @Override
        public final Builder contextScopeType(String contextScopeType) {
            this.contextScopeType = contextScopeType;
            return this;
        }

        public final String getContextId() {
            return contextId;
        }

        public final void setContextId(String contextId) {
            this.contextId = contextId;
        }

        @Override
        public final Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        @Override
        public QuotaContextInfo build() {
            return new QuotaContextInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
