/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * With Service Quotas, you can view and manage your quotas easily as your Amazon Web Services workloads grow. Quotas,
 * also referred to as limits, are the maximum number of resources that you can create in your Amazon Web Services
 * account. For more information, see the <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/">Service
 * Quotas User Guide</a>.
 * </p>
 * <p>
 * You need Amazon Web Services CLI version 2.13.20 or higher to view and manage resource-level quotas such as
 * <code>Instances per domain</code> for Amazon OpenSearch Service.
 * </p>
 */
package software.amazon.awssdk.services.servicequotas;