/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasClient;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasServiceClientConfiguration;
import software.amazon.awssdk.services.servicequotas.internal.ServiceQuotasServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.servicequotas.model.AccessDeniedException;
import software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.AwsServiceAccessNotEnabledException;
import software.amazon.awssdk.services.servicequotas.model.CreateSupportCaseRequest;
import software.amazon.awssdk.services.servicequotas.model.CreateSupportCaseResponse;
import software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.DependencyAccessDeniedException;
import software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeRequest;
import software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeResponse;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.IllegalArgumentException;
import software.amazon.awssdk.services.servicequotas.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.servicequotas.model.InvalidResourceStateException;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServicesRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServicesResponse;
import software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.servicequotas.model.NoAvailableOrganizationException;
import software.amazon.awssdk.services.servicequotas.model.NoSuchResourceException;
import software.amazon.awssdk.services.servicequotas.model.OrganizationNotInAllFeaturesModeException;
import software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.QuotaExceededException;
import software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest;
import software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseResponse;
import software.amazon.awssdk.services.servicequotas.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.servicequotas.model.ServiceException;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotaTemplateNotInUseException;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasException;
import software.amazon.awssdk.services.servicequotas.model.TagPolicyViolationException;
import software.amazon.awssdk.services.servicequotas.model.TagResourceRequest;
import software.amazon.awssdk.services.servicequotas.model.TagResourceResponse;
import software.amazon.awssdk.services.servicequotas.model.TemplatesNotAvailableInRegionException;
import software.amazon.awssdk.services.servicequotas.model.TooManyRequestsException;
import software.amazon.awssdk.services.servicequotas.model.TooManyTagsException;
import software.amazon.awssdk.services.servicequotas.model.UntagResourceRequest;
import software.amazon.awssdk.services.servicequotas.model.UntagResourceResponse;
import software.amazon.awssdk.services.servicequotas.transform.AssociateServiceQuotaTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.CreateSupportCaseRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.DeleteServiceQuotaIncreaseRequestFromTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.DisassociateServiceQuotaTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetAssociationForServiceQuotaTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetAwsDefaultServiceQuotaRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetRequestedServiceQuotaChangeRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetServiceQuotaIncreaseRequestFromTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.GetServiceQuotaRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListAwsDefaultServiceQuotasRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListRequestedServiceQuotaChangeHistoryByQuotaRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListRequestedServiceQuotaChangeHistoryRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListServiceQuotaIncreaseRequestsInTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListServiceQuotasRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListServicesRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.PutServiceQuotaIncreaseRequestIntoTemplateRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.RequestServiceQuotaIncreaseRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.servicequotas.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultServiceQuotasClient
implements ServiceQuotasClient {
    private static final Logger log = Logger.loggerFor(DefaultServiceQuotasClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultServiceQuotasClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Service_Quotas#2.34.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateServiceQuotaTemplateResponse associateServiceQuotaTemplate(AssociateServiceQuotaTemplateRequest associateServiceQuotaTemplateRequest) throws DependencyAccessDeniedException, AccessDeniedException, ServiceException, TooManyRequestsException, AwsServiceAccessNotEnabledException, OrganizationNotInAllFeaturesModeException, TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateServiceQuotaTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateServiceQuotaTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, associateServiceQuotaTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateServiceQuotaTemplate");
            AssociateServiceQuotaTemplateResponse associateServiceQuotaTemplateResponse = (AssociateServiceQuotaTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateServiceQuotaTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateServiceQuotaTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateServiceQuotaTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateServiceQuotaTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$associateServiceQuotaTemplate$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSupportCaseResponse createSupportCase(CreateSupportCaseRequest createSupportCaseRequest) throws DependencyAccessDeniedException, ResourceAlreadyExistsException, AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidResourceStateException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSupportCaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSupportCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, createSupportCaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSupportCase");
            CreateSupportCaseResponse createSupportCaseResponse = (CreateSupportCaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSupportCase").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createSupportCaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSupportCaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSupportCaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$createSupportCase$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServiceQuotaIncreaseRequestFromTemplateResponse deleteServiceQuotaIncreaseRequestFromTemplate(DeleteServiceQuotaIncreaseRequestFromTemplateRequest deleteServiceQuotaIncreaseRequestFromTemplateRequest) throws AccessDeniedException, ServiceException, DependencyAccessDeniedException, TooManyRequestsException, NoSuchResourceException, IllegalArgumentException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceQuotaIncreaseRequestFromTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteServiceQuotaIncreaseRequestFromTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, deleteServiceQuotaIncreaseRequestFromTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteServiceQuotaIncreaseRequestFromTemplate");
            DeleteServiceQuotaIncreaseRequestFromTemplateResponse deleteServiceQuotaIncreaseRequestFromTemplateResponse = (DeleteServiceQuotaIncreaseRequestFromTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServiceQuotaIncreaseRequestFromTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteServiceQuotaIncreaseRequestFromTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteServiceQuotaIncreaseRequestFromTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteServiceQuotaIncreaseRequestFromTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$deleteServiceQuotaIncreaseRequestFromTemplate$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateServiceQuotaTemplateResponse disassociateServiceQuotaTemplate(DisassociateServiceQuotaTemplateRequest disassociateServiceQuotaTemplateRequest) throws DependencyAccessDeniedException, ServiceQuotaTemplateNotInUseException, AccessDeniedException, ServiceException, TooManyRequestsException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateServiceQuotaTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateServiceQuotaTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, disassociateServiceQuotaTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateServiceQuotaTemplate");
            DisassociateServiceQuotaTemplateResponse disassociateServiceQuotaTemplateResponse = (DisassociateServiceQuotaTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateServiceQuotaTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateServiceQuotaTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateServiceQuotaTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateServiceQuotaTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$disassociateServiceQuotaTemplate$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAwsDefaultServiceQuotaResponse getAWSDefaultServiceQuota(GetAwsDefaultServiceQuotaRequest getAwsDefaultServiceQuotaRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAwsDefaultServiceQuotaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAwsDefaultServiceQuotaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, getAwsDefaultServiceQuotaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAWSDefaultServiceQuota");
            GetAwsDefaultServiceQuotaResponse getAwsDefaultServiceQuotaResponse = (GetAwsDefaultServiceQuotaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAWSDefaultServiceQuota").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAwsDefaultServiceQuotaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAwsDefaultServiceQuotaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAwsDefaultServiceQuotaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$getAWSDefaultServiceQuota$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAssociationForServiceQuotaTemplateResponse getAssociationForServiceQuotaTemplate(GetAssociationForServiceQuotaTemplateRequest getAssociationForServiceQuotaTemplateRequest) throws DependencyAccessDeniedException, ServiceQuotaTemplateNotInUseException, AccessDeniedException, ServiceException, TooManyRequestsException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAssociationForServiceQuotaTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAssociationForServiceQuotaTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, getAssociationForServiceQuotaTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAssociationForServiceQuotaTemplate");
            GetAssociationForServiceQuotaTemplateResponse getAssociationForServiceQuotaTemplateResponse = (GetAssociationForServiceQuotaTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAssociationForServiceQuotaTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAssociationForServiceQuotaTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAssociationForServiceQuotaTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAssociationForServiceQuotaTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$getAssociationForServiceQuotaTemplate$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRequestedServiceQuotaChangeResponse getRequestedServiceQuotaChange(GetRequestedServiceQuotaChangeRequest getRequestedServiceQuotaChangeRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRequestedServiceQuotaChangeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRequestedServiceQuotaChangeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, getRequestedServiceQuotaChangeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRequestedServiceQuotaChange");
            GetRequestedServiceQuotaChangeResponse getRequestedServiceQuotaChangeResponse = (GetRequestedServiceQuotaChangeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRequestedServiceQuotaChange").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRequestedServiceQuotaChangeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRequestedServiceQuotaChangeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRequestedServiceQuotaChangeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$getRequestedServiceQuotaChange$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServiceQuotaResponse getServiceQuota(GetServiceQuotaRequest getServiceQuotaRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceQuotaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getServiceQuotaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, getServiceQuotaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServiceQuota");
            GetServiceQuotaResponse getServiceQuotaResponse = (GetServiceQuotaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServiceQuota").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getServiceQuotaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServiceQuotaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServiceQuotaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$getServiceQuota$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServiceQuotaIncreaseRequestFromTemplateResponse getServiceQuotaIncreaseRequestFromTemplate(GetServiceQuotaIncreaseRequestFromTemplateRequest getServiceQuotaIncreaseRequestFromTemplateRequest) throws AccessDeniedException, DependencyAccessDeniedException, ServiceException, TooManyRequestsException, NoSuchResourceException, IllegalArgumentException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServiceQuotaIncreaseRequestFromTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getServiceQuotaIncreaseRequestFromTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, getServiceQuotaIncreaseRequestFromTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServiceQuotaIncreaseRequestFromTemplate");
            GetServiceQuotaIncreaseRequestFromTemplateResponse getServiceQuotaIncreaseRequestFromTemplateResponse = (GetServiceQuotaIncreaseRequestFromTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServiceQuotaIncreaseRequestFromTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getServiceQuotaIncreaseRequestFromTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServiceQuotaIncreaseRequestFromTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServiceQuotaIncreaseRequestFromTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$getServiceQuotaIncreaseRequestFromTemplate$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAwsDefaultServiceQuotasResponse listAWSDefaultServiceQuotas(ListAwsDefaultServiceQuotasRequest listAwsDefaultServiceQuotasRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAwsDefaultServiceQuotasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAwsDefaultServiceQuotasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, listAwsDefaultServiceQuotasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAWSDefaultServiceQuotas");
            ListAwsDefaultServiceQuotasResponse listAwsDefaultServiceQuotasResponse = (ListAwsDefaultServiceQuotasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAWSDefaultServiceQuotas").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAwsDefaultServiceQuotasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAwsDefaultServiceQuotasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAwsDefaultServiceQuotasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$listAWSDefaultServiceQuotas$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRequestedServiceQuotaChangeHistoryResponse listRequestedServiceQuotaChangeHistory(ListRequestedServiceQuotaChangeHistoryRequest listRequestedServiceQuotaChangeHistoryRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRequestedServiceQuotaChangeHistoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRequestedServiceQuotaChangeHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, listRequestedServiceQuotaChangeHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRequestedServiceQuotaChangeHistory");
            ListRequestedServiceQuotaChangeHistoryResponse listRequestedServiceQuotaChangeHistoryResponse = (ListRequestedServiceQuotaChangeHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRequestedServiceQuotaChangeHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRequestedServiceQuotaChangeHistoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRequestedServiceQuotaChangeHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRequestedServiceQuotaChangeHistoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$listRequestedServiceQuotaChangeHistory$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRequestedServiceQuotaChangeHistoryByQuotaResponse listRequestedServiceQuotaChangeHistoryByQuota(ListRequestedServiceQuotaChangeHistoryByQuotaRequest listRequestedServiceQuotaChangeHistoryByQuotaRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRequestedServiceQuotaChangeHistoryByQuotaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRequestedServiceQuotaChangeHistoryByQuotaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, listRequestedServiceQuotaChangeHistoryByQuotaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRequestedServiceQuotaChangeHistoryByQuota");
            ListRequestedServiceQuotaChangeHistoryByQuotaResponse listRequestedServiceQuotaChangeHistoryByQuotaResponse = (ListRequestedServiceQuotaChangeHistoryByQuotaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRequestedServiceQuotaChangeHistoryByQuota").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRequestedServiceQuotaChangeHistoryByQuotaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRequestedServiceQuotaChangeHistoryByQuotaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRequestedServiceQuotaChangeHistoryByQuotaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$listRequestedServiceQuotaChangeHistoryByQuota$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServiceQuotaIncreaseRequestsInTemplateResponse listServiceQuotaIncreaseRequestsInTemplate(ListServiceQuotaIncreaseRequestsInTemplateRequest listServiceQuotaIncreaseRequestsInTemplateRequest) throws AccessDeniedException, DependencyAccessDeniedException, ServiceException, TooManyRequestsException, IllegalArgumentException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceQuotaIncreaseRequestsInTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServiceQuotaIncreaseRequestsInTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, listServiceQuotaIncreaseRequestsInTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceQuotaIncreaseRequestsInTemplate");
            ListServiceQuotaIncreaseRequestsInTemplateResponse listServiceQuotaIncreaseRequestsInTemplateResponse = (ListServiceQuotaIncreaseRequestsInTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceQuotaIncreaseRequestsInTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listServiceQuotaIncreaseRequestsInTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServiceQuotaIncreaseRequestsInTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServiceQuotaIncreaseRequestsInTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$listServiceQuotaIncreaseRequestsInTemplate$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServiceQuotasResponse listServiceQuotas(ListServiceQuotasRequest listServiceQuotasRequest) throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServiceQuotasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServiceQuotasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, listServiceQuotasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServiceQuotas");
            ListServiceQuotasResponse listServiceQuotasResponse = (ListServiceQuotasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServiceQuotas").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listServiceQuotasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServiceQuotasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServiceQuotasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$listServiceQuotas$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServicesResponse listServices(ListServicesRequest listServicesRequest) throws AccessDeniedException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServicesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, listServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServices");
            ListServicesResponse listServicesResponse = (ListServicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listServicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$listServices$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws TooManyRequestsException, NoSuchResourceException, IllegalArgumentException, AccessDeniedException, ServiceException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$listTagsForResource$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutServiceQuotaIncreaseRequestIntoTemplateResponse putServiceQuotaIncreaseRequestIntoTemplate(PutServiceQuotaIncreaseRequestIntoTemplateRequest putServiceQuotaIncreaseRequestIntoTemplateRequest) throws AccessDeniedException, DependencyAccessDeniedException, ServiceException, TooManyRequestsException, IllegalArgumentException, QuotaExceededException, NoSuchResourceException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutServiceQuotaIncreaseRequestIntoTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putServiceQuotaIncreaseRequestIntoTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, putServiceQuotaIncreaseRequestIntoTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutServiceQuotaIncreaseRequestIntoTemplate");
            PutServiceQuotaIncreaseRequestIntoTemplateResponse putServiceQuotaIncreaseRequestIntoTemplateResponse = (PutServiceQuotaIncreaseRequestIntoTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutServiceQuotaIncreaseRequestIntoTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putServiceQuotaIncreaseRequestIntoTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutServiceQuotaIncreaseRequestIntoTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putServiceQuotaIncreaseRequestIntoTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$putServiceQuotaIncreaseRequestIntoTemplate$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestServiceQuotaIncreaseResponse requestServiceQuotaIncrease(RequestServiceQuotaIncreaseRequest requestServiceQuotaIncreaseRequest) throws DependencyAccessDeniedException, QuotaExceededException, ResourceAlreadyExistsException, AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidResourceStateException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RequestServiceQuotaIncreaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)requestServiceQuotaIncreaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, requestServiceQuotaIncreaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RequestServiceQuotaIncrease");
            RequestServiceQuotaIncreaseResponse requestServiceQuotaIncreaseResponse = (RequestServiceQuotaIncreaseResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RequestServiceQuotaIncrease").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)requestServiceQuotaIncreaseRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RequestServiceQuotaIncreaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return requestServiceQuotaIncreaseResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$requestServiceQuotaIncrease$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws TooManyRequestsException, NoSuchResourceException, TooManyTagsException, TagPolicyViolationException, IllegalArgumentException, AccessDeniedException, ServiceException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$tagResource$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws TooManyRequestsException, NoSuchResourceException, IllegalArgumentException, AccessDeniedException, ServiceException, AwsServiceException, SdkClientException, ServiceQuotasException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "InvalidResourceStateException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
                }
                case "IllegalArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IllegalArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IllegalArgumentException::builder).build());
                }
                case "ServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "AWSServiceAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AWSServiceAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AwsServiceAccessNotEnabledException::builder).build());
                }
                case "DependencyAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DependencyAccessDeniedException::builder).build());
                }
                case "NoSuchResourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchResourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchResourceException::builder).build());
                }
                case "QuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QuotaExceededException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "TemplatesNotAvailableInRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TemplatesNotAvailableInRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TemplatesNotAvailableInRegionException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "TagPolicyViolationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagPolicyViolationException::builder).build());
                }
                case "ServiceQuotaTemplateNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaTemplateNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaTemplateNotInUseException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultServiceQuotasClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Service Quotas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultServiceQuotasClient.lambda$untagResource$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "servicequotas";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ServiceQuotasServiceClientConfigurationBuilder serviceConfigBuilder = new ServiceQuotasServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ServiceQuotasException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final ServiceQuotasServiceClientConfiguration serviceClientConfiguration() {
        return new ServiceQuotasServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$untagResource$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$requestServiceQuotaIncrease$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putServiceQuotaIncreaseRequestIntoTemplate$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServices$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServiceQuotas$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServiceQuotaIncreaseRequestsInTemplate$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRequestedServiceQuotaChangeHistoryByQuota$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRequestedServiceQuotaChangeHistory$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAWSDefaultServiceQuotas$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServiceQuotaIncreaseRequestFromTemplate$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServiceQuota$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRequestedServiceQuotaChange$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAssociationForServiceQuotaTemplate$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAWSDefaultServiceQuota$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateServiceQuotaTemplate$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteServiceQuotaIncreaseRequestFromTemplate$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSupportCase$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateServiceQuotaTemplate$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

