/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicequotas.model.ExclusionQuotaListCopier;
import software.amazon.awssdk.services.servicequotas.model.OptInLevel;
import software.amazon.awssdk.services.servicequotas.model.OptInStatus;
import software.amazon.awssdk.services.servicequotas.model.OptInType;
import software.amazon.awssdk.services.servicequotas.model.QuotaInfo;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAutoManagementConfigurationResponse
extends ServiceQuotasResponse
implements ToCopyableBuilder<Builder, GetAutoManagementConfigurationResponse> {
    private static final SdkField<String> OPT_IN_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptInLevel").getter(GetAutoManagementConfigurationResponse.getter(GetAutoManagementConfigurationResponse::optInLevelAsString)).setter(GetAutoManagementConfigurationResponse.setter(Builder::optInLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptInLevel").build()}).build();
    private static final SdkField<String> OPT_IN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptInType").getter(GetAutoManagementConfigurationResponse.getter(GetAutoManagementConfigurationResponse::optInTypeAsString)).setter(GetAutoManagementConfigurationResponse.setter(Builder::optInType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptInType").build()}).build();
    private static final SdkField<String> NOTIFICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationArn").getter(GetAutoManagementConfigurationResponse.getter(GetAutoManagementConfigurationResponse::notificationArn)).setter(GetAutoManagementConfigurationResponse.setter(Builder::notificationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationArn").build()}).build();
    private static final SdkField<String> OPT_IN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptInStatus").getter(GetAutoManagementConfigurationResponse.getter(GetAutoManagementConfigurationResponse::optInStatusAsString)).setter(GetAutoManagementConfigurationResponse.setter(Builder::optInStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptInStatus").build()}).build();
    private static final SdkField<Map<String, List<QuotaInfo>>> EXCLUSION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ExclusionList").getter(GetAutoManagementConfigurationResponse.getter(GetAutoManagementConfigurationResponse::exclusionList)).setter(GetAutoManagementConfigurationResponse.setter(Builder::exclusionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionList").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QuotaInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_IN_LEVEL_FIELD, OPT_IN_TYPE_FIELD, NOTIFICATION_ARN_FIELD, OPT_IN_STATUS_FIELD, EXCLUSION_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAutoManagementConfigurationResponse.memberNameToFieldInitializer();
    private final String optInLevel;
    private final String optInType;
    private final String notificationArn;
    private final String optInStatus;
    private final Map<String, List<QuotaInfo>> exclusionList;

    private GetAutoManagementConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.optInLevel = builder.optInLevel;
        this.optInType = builder.optInType;
        this.notificationArn = builder.notificationArn;
        this.optInStatus = builder.optInStatus;
        this.exclusionList = builder.exclusionList;
    }

    public final OptInLevel optInLevel() {
        return OptInLevel.fromValue(this.optInLevel);
    }

    public final String optInLevelAsString() {
        return this.optInLevel;
    }

    public final OptInType optInType() {
        return OptInType.fromValue(this.optInType);
    }

    public final String optInTypeAsString() {
        return this.optInType;
    }

    public final String notificationArn() {
        return this.notificationArn;
    }

    public final OptInStatus optInStatus() {
        return OptInStatus.fromValue(this.optInStatus);
    }

    public final String optInStatusAsString() {
        return this.optInStatus;
    }

    public final boolean hasExclusionList() {
        return this.exclusionList != null && !(this.exclusionList instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<QuotaInfo>> exclusionList() {
        return this.exclusionList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.optInLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.optInTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.optInStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionList() ? this.exclusionList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutoManagementConfigurationResponse)) {
            return false;
        }
        GetAutoManagementConfigurationResponse other = (GetAutoManagementConfigurationResponse)((Object)obj);
        return Objects.equals(this.optInLevelAsString(), other.optInLevelAsString()) && Objects.equals(this.optInTypeAsString(), other.optInTypeAsString()) && Objects.equals(this.notificationArn(), other.notificationArn()) && Objects.equals(this.optInStatusAsString(), other.optInStatusAsString()) && this.hasExclusionList() == other.hasExclusionList() && Objects.equals(this.exclusionList(), other.exclusionList());
    }

    public final String toString() {
        return ToString.builder((String)"GetAutoManagementConfigurationResponse").add("OptInLevel", (Object)this.optInLevelAsString()).add("OptInType", (Object)this.optInTypeAsString()).add("NotificationArn", (Object)this.notificationArn()).add("OptInStatus", (Object)this.optInStatusAsString()).add("ExclusionList", this.hasExclusionList() ? this.exclusionList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptInLevel": {
                return Optional.ofNullable(clazz.cast(this.optInLevelAsString()));
            }
            case "OptInType": {
                return Optional.ofNullable(clazz.cast(this.optInTypeAsString()));
            }
            case "NotificationArn": {
                return Optional.ofNullable(clazz.cast(this.notificationArn()));
            }
            case "OptInStatus": {
                return Optional.ofNullable(clazz.cast(this.optInStatusAsString()));
            }
            case "ExclusionList": {
                return Optional.ofNullable(clazz.cast(this.exclusionList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OptInLevel", OPT_IN_LEVEL_FIELD);
        map.put("OptInType", OPT_IN_TYPE_FIELD);
        map.put("NotificationArn", NOTIFICATION_ARN_FIELD);
        map.put("OptInStatus", OPT_IN_STATUS_FIELD);
        map.put("ExclusionList", EXCLUSION_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAutoManagementConfigurationResponse, T> g) {
        return obj -> g.apply((GetAutoManagementConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceQuotasResponse.BuilderImpl
    implements Builder {
        private String optInLevel;
        private String optInType;
        private String notificationArn;
        private String optInStatus;
        private Map<String, List<QuotaInfo>> exclusionList = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutoManagementConfigurationResponse model) {
            super(model);
            this.optInLevel(model.optInLevel);
            this.optInType(model.optInType);
            this.notificationArn(model.notificationArn);
            this.optInStatus(model.optInStatus);
            this.exclusionList(model.exclusionList);
        }

        public final String getOptInLevel() {
            return this.optInLevel;
        }

        public final void setOptInLevel(String optInLevel) {
            this.optInLevel = optInLevel;
        }

        @Override
        public final Builder optInLevel(String optInLevel) {
            this.optInLevel = optInLevel;
            return this;
        }

        @Override
        public final Builder optInLevel(OptInLevel optInLevel) {
            this.optInLevel(optInLevel == null ? null : optInLevel.toString());
            return this;
        }

        public final String getOptInType() {
            return this.optInType;
        }

        public final void setOptInType(String optInType) {
            this.optInType = optInType;
        }

        @Override
        public final Builder optInType(String optInType) {
            this.optInType = optInType;
            return this;
        }

        @Override
        public final Builder optInType(OptInType optInType) {
            this.optInType(optInType == null ? null : optInType.toString());
            return this;
        }

        public final String getNotificationArn() {
            return this.notificationArn;
        }

        public final void setNotificationArn(String notificationArn) {
            this.notificationArn = notificationArn;
        }

        @Override
        public final Builder notificationArn(String notificationArn) {
            this.notificationArn = notificationArn;
            return this;
        }

        public final String getOptInStatus() {
            return this.optInStatus;
        }

        public final void setOptInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
        }

        @Override
        public final Builder optInStatus(String optInStatus) {
            this.optInStatus = optInStatus;
            return this;
        }

        @Override
        public final Builder optInStatus(OptInStatus optInStatus) {
            this.optInStatus(optInStatus == null ? null : optInStatus.toString());
            return this;
        }

        public final Map<String, List<QuotaInfo.Builder>> getExclusionList() {
            Map<String, List<QuotaInfo.Builder>> result = ExclusionQuotaListCopier.copyToBuilder(this.exclusionList);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setExclusionList(Map<String, ? extends Collection<QuotaInfo.BuilderImpl>> exclusionList) {
            this.exclusionList = ExclusionQuotaListCopier.copyFromBuilder(exclusionList);
        }

        @Override
        public final Builder exclusionList(Map<String, ? extends Collection<QuotaInfo>> exclusionList) {
            this.exclusionList = ExclusionQuotaListCopier.copy(exclusionList);
            return this;
        }

        @Override
        public GetAutoManagementConfigurationResponse build() {
            return new GetAutoManagementConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServiceQuotasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAutoManagementConfigurationResponse> {
        public Builder optInLevel(String var1);

        public Builder optInLevel(OptInLevel var1);

        public Builder optInType(String var1);

        public Builder optInType(OptInType var1);

        public Builder notificationArn(String var1);

        public Builder optInStatus(String var1);

        public Builder optInStatus(OptInStatus var1);

        public Builder exclusionList(Map<String, ? extends Collection<QuotaInfo>> var1);
    }
}

