/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OptInType {
    NOTIFY_ONLY("NotifyOnly"),
    NOTIFY_AND_ADJUST("NotifyAndAdjust"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OptInType> VALUE_MAP;
    private final String value;

    private OptInType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OptInType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OptInType> knownValues() {
        EnumSet<OptInType> knownValues = EnumSet.allOf(OptInType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OptInType.class, OptInType::toString);
    }
}

