/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuotaInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuotaInfo> {
    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuotaCode").getter(QuotaInfo.getter(QuotaInfo::quotaCode)).setter(QuotaInfo.setter(Builder::quotaCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaCode").build()}).build();
    private static final SdkField<String> QUOTA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuotaName").getter(QuotaInfo.getter(QuotaInfo::quotaName)).setter(QuotaInfo.setter(Builder::quotaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUOTA_CODE_FIELD, QUOTA_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QuotaInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String quotaCode;
    private final String quotaName;

    private QuotaInfo(BuilderImpl builder) {
        this.quotaCode = builder.quotaCode;
        this.quotaName = builder.quotaName;
    }

    public final String quotaCode() {
        return this.quotaCode;
    }

    public final String quotaName() {
        return this.quotaName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.quotaName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuotaInfo)) {
            return false;
        }
        QuotaInfo other = (QuotaInfo)obj;
        return Objects.equals(this.quotaCode(), other.quotaCode()) && Objects.equals(this.quotaName(), other.quotaName());
    }

    public final String toString() {
        return ToString.builder((String)"QuotaInfo").add("QuotaCode", (Object)this.quotaCode()).add("QuotaName", (Object)this.quotaName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuotaCode": {
                return Optional.ofNullable(clazz.cast(this.quotaCode()));
            }
            case "QuotaName": {
                return Optional.ofNullable(clazz.cast(this.quotaName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("QuotaCode", QUOTA_CODE_FIELD);
        map.put("QuotaName", QUOTA_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QuotaInfo, T> g) {
        return obj -> g.apply((QuotaInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String quotaCode;
        private String quotaName;

        private BuilderImpl() {
        }

        private BuilderImpl(QuotaInfo model) {
            this.quotaCode(model.quotaCode);
            this.quotaName(model.quotaName);
        }

        public final String getQuotaCode() {
            return this.quotaCode;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final String getQuotaName() {
            return this.quotaName;
        }

        public final void setQuotaName(String quotaName) {
            this.quotaName = quotaName;
        }

        @Override
        public final Builder quotaName(String quotaName) {
            this.quotaName = quotaName;
            return this;
        }

        public QuotaInfo build() {
            return new QuotaInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuotaInfo> {
        public Builder quotaCode(String var1);

        public Builder quotaName(String var1);
    }
}

