/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicequotas.model.ExclusionListCopier;
import software.amazon.awssdk.services.servicequotas.model.OptInType;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAutoManagementRequest
extends ServiceQuotasRequest
implements ToCopyableBuilder<Builder, UpdateAutoManagementRequest> {
    private static final SdkField<String> OPT_IN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptInType").getter(UpdateAutoManagementRequest.getter(UpdateAutoManagementRequest::optInTypeAsString)).setter(UpdateAutoManagementRequest.setter(Builder::optInType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptInType").build()}).build();
    private static final SdkField<String> NOTIFICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationArn").getter(UpdateAutoManagementRequest.getter(UpdateAutoManagementRequest::notificationArn)).setter(UpdateAutoManagementRequest.setter(Builder::notificationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationArn").build()}).build();
    private static final SdkField<Map<String, List<String>>> EXCLUSION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ExclusionList").getter(UpdateAutoManagementRequest.getter(UpdateAutoManagementRequest::exclusionList)).setter(UpdateAutoManagementRequest.setter(Builder::exclusionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionList").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPT_IN_TYPE_FIELD, NOTIFICATION_ARN_FIELD, EXCLUSION_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAutoManagementRequest.memberNameToFieldInitializer();
    private final String optInType;
    private final String notificationArn;
    private final Map<String, List<String>> exclusionList;

    private UpdateAutoManagementRequest(BuilderImpl builder) {
        super(builder);
        this.optInType = builder.optInType;
        this.notificationArn = builder.notificationArn;
        this.exclusionList = builder.exclusionList;
    }

    public final OptInType optInType() {
        return OptInType.fromValue(this.optInType);
    }

    public final String optInTypeAsString() {
        return this.optInType;
    }

    public final String notificationArn() {
        return this.notificationArn;
    }

    public final boolean hasExclusionList() {
        return this.exclusionList != null && !(this.exclusionList instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> exclusionList() {
        return this.exclusionList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.optInTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionList() ? this.exclusionList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutoManagementRequest)) {
            return false;
        }
        UpdateAutoManagementRequest other = (UpdateAutoManagementRequest)((Object)obj);
        return Objects.equals(this.optInTypeAsString(), other.optInTypeAsString()) && Objects.equals(this.notificationArn(), other.notificationArn()) && this.hasExclusionList() == other.hasExclusionList() && Objects.equals(this.exclusionList(), other.exclusionList());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAutoManagementRequest").add("OptInType", (Object)this.optInTypeAsString()).add("NotificationArn", (Object)this.notificationArn()).add("ExclusionList", this.hasExclusionList() ? this.exclusionList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptInType": {
                return Optional.ofNullable(clazz.cast(this.optInTypeAsString()));
            }
            case "NotificationArn": {
                return Optional.ofNullable(clazz.cast(this.notificationArn()));
            }
            case "ExclusionList": {
                return Optional.ofNullable(clazz.cast(this.exclusionList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OptInType", OPT_IN_TYPE_FIELD);
        map.put("NotificationArn", NOTIFICATION_ARN_FIELD);
        map.put("ExclusionList", EXCLUSION_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutoManagementRequest, T> g) {
        return obj -> g.apply((UpdateAutoManagementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceQuotasRequest.BuilderImpl
    implements Builder {
        private String optInType;
        private String notificationArn;
        private Map<String, List<String>> exclusionList = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutoManagementRequest model) {
            super(model);
            this.optInType(model.optInType);
            this.notificationArn(model.notificationArn);
            this.exclusionList(model.exclusionList);
        }

        public final String getOptInType() {
            return this.optInType;
        }

        public final void setOptInType(String optInType) {
            this.optInType = optInType;
        }

        @Override
        public final Builder optInType(String optInType) {
            this.optInType = optInType;
            return this;
        }

        @Override
        public final Builder optInType(OptInType optInType) {
            this.optInType(optInType == null ? null : optInType.toString());
            return this;
        }

        public final String getNotificationArn() {
            return this.notificationArn;
        }

        public final void setNotificationArn(String notificationArn) {
            this.notificationArn = notificationArn;
        }

        @Override
        public final Builder notificationArn(String notificationArn) {
            this.notificationArn = notificationArn;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getExclusionList() {
            if (this.exclusionList instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.exclusionList;
        }

        public final void setExclusionList(Map<String, ? extends Collection<String>> exclusionList) {
            this.exclusionList = ExclusionListCopier.copy(exclusionList);
        }

        @Override
        public final Builder exclusionList(Map<String, ? extends Collection<String>> exclusionList) {
            this.exclusionList = ExclusionListCopier.copy(exclusionList);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAutoManagementRequest build() {
            return new UpdateAutoManagementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServiceQuotasRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAutoManagementRequest> {
        public Builder optInType(String var1);

        public Builder optInType(OptInType var1);

        public Builder notificationArn(String var1);

        public Builder exclusionList(Map<String, ? extends Collection<String>> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

