/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the DKIM attributes of a verified email address or a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IdentityDkimAttributes implements ToCopyableBuilder<IdentityDkimAttributes.Builder, IdentityDkimAttributes> {
    private final Boolean dkimEnabled;

    private final String dkimVerificationStatus;

    private final List<String> dkimTokens;

    private IdentityDkimAttributes(BuilderImpl builder) {
        this.dkimEnabled = builder.dkimEnabled;
        this.dkimVerificationStatus = builder.dkimVerificationStatus;
        this.dkimTokens = builder.dkimTokens;
    }

    /**
     * <p>
     * True if DKIM signing is enabled for email sent from the identity; false otherwise. The default value is true.
     * </p>
     * 
     * @return True if DKIM signing is enabled for email sent from the identity; false otherwise. The default value is
     *         true.
     */
    public Boolean dkimEnabled() {
        return dkimEnabled;
    }

    /**
     * <p>
     * Describes whether Amazon SES has successfully verified the DKIM DNS records (tokens) published in the domain
     * name's DNS. (This only applies to domain identities, not email address identities.)
     * </p>
     * 
     * @return Describes whether Amazon SES has successfully verified the DKIM DNS records (tokens) published in the
     *         domain name's DNS. (This only applies to domain identities, not email address identities.)
     * @see VerificationStatus
     */
    public String dkimVerificationStatus() {
        return dkimVerificationStatus;
    }

    /**
     * <p>
     * A set of character strings that represent the domain's identity. Using these tokens, you will need to create DNS
     * CNAME records that point to DKIM public keys hosted by Amazon SES. Amazon Web Services will eventually detect
     * that you have updated your DNS records; this detection process may take up to 72 hours. Upon successful
     * detection, Amazon SES will be able to DKIM-sign email originating from that domain. (This only applies to domain
     * identities, not email address identities.)
     * </p>
     * <p>
     * For more information about creating DNS records using DKIM tokens, go to the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * 
     * @return A set of character strings that represent the domain's identity. Using these tokens, you will need to
     *         create DNS CNAME records that point to DKIM public keys hosted by Amazon SES. Amazon Web Services will
     *         eventually detect that you have updated your DNS records; this detection process may take up to 72 hours.
     *         Upon successful detection, Amazon SES will be able to DKIM-sign email originating from that domain. (This
     *         only applies to domain identities, not email address identities.)</p>
     *         <p>
     *         For more information about creating DNS records using DKIM tokens, go to the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES
     *         Developer Guide</a>.
     */
    public List<String> dkimTokens() {
        return dkimTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dkimEnabled() == null) ? 0 : dkimEnabled().hashCode());
        hashCode = 31 * hashCode + ((dkimVerificationStatus() == null) ? 0 : dkimVerificationStatus().hashCode());
        hashCode = 31 * hashCode + ((dkimTokens() == null) ? 0 : dkimTokens().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityDkimAttributes)) {
            return false;
        }
        IdentityDkimAttributes other = (IdentityDkimAttributes) obj;
        if (other.dkimEnabled() == null ^ this.dkimEnabled() == null) {
            return false;
        }
        if (other.dkimEnabled() != null && !other.dkimEnabled().equals(this.dkimEnabled())) {
            return false;
        }
        if (other.dkimVerificationStatus() == null ^ this.dkimVerificationStatus() == null) {
            return false;
        }
        if (other.dkimVerificationStatus() != null && !other.dkimVerificationStatus().equals(this.dkimVerificationStatus())) {
            return false;
        }
        if (other.dkimTokens() == null ^ this.dkimTokens() == null) {
            return false;
        }
        if (other.dkimTokens() != null && !other.dkimTokens().equals(this.dkimTokens())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (dkimEnabled() != null) {
            sb.append("DkimEnabled: ").append(dkimEnabled()).append(",");
        }
        if (dkimVerificationStatus() != null) {
            sb.append("DkimVerificationStatus: ").append(dkimVerificationStatus()).append(",");
        }
        if (dkimTokens() != null) {
            sb.append("DkimTokens: ").append(dkimTokens()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, IdentityDkimAttributes> {
        /**
         * <p>
         * True if DKIM signing is enabled for email sent from the identity; false otherwise. The default value is true.
         * </p>
         * 
         * @param dkimEnabled
         *        True if DKIM signing is enabled for email sent from the identity; false otherwise. The default value
         *        is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dkimEnabled(Boolean dkimEnabled);

        /**
         * <p>
         * Describes whether Amazon SES has successfully verified the DKIM DNS records (tokens) published in the domain
         * name's DNS. (This only applies to domain identities, not email address identities.)
         * </p>
         * 
         * @param dkimVerificationStatus
         *        Describes whether Amazon SES has successfully verified the DKIM DNS records (tokens) published in the
         *        domain name's DNS. (This only applies to domain identities, not email address identities.)
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder dkimVerificationStatus(String dkimVerificationStatus);

        /**
         * <p>
         * Describes whether Amazon SES has successfully verified the DKIM DNS records (tokens) published in the domain
         * name's DNS. (This only applies to domain identities, not email address identities.)
         * </p>
         * 
         * @param dkimVerificationStatus
         *        Describes whether Amazon SES has successfully verified the DKIM DNS records (tokens) published in the
         *        domain name's DNS. (This only applies to domain identities, not email address identities.)
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder dkimVerificationStatus(VerificationStatus dkimVerificationStatus);

        /**
         * <p>
         * A set of character strings that represent the domain's identity. Using these tokens, you will need to create
         * DNS CNAME records that point to DKIM public keys hosted by Amazon SES. Amazon Web Services will eventually
         * detect that you have updated your DNS records; this detection process may take up to 72 hours. Upon
         * successful detection, Amazon SES will be able to DKIM-sign email originating from that domain. (This only
         * applies to domain identities, not email address identities.)
         * </p>
         * <p>
         * For more information about creating DNS records using DKIM tokens, go to the <a
         * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer
         * Guide</a>.
         * </p>
         * 
         * @param dkimTokens
         *        A set of character strings that represent the domain's identity. Using these tokens, you will need to
         *        create DNS CNAME records that point to DKIM public keys hosted by Amazon SES. Amazon Web Services will
         *        eventually detect that you have updated your DNS records; this detection process may take up to 72
         *        hours. Upon successful detection, Amazon SES will be able to DKIM-sign email originating from that
         *        domain. (This only applies to domain identities, not email address identities.)</p>
         *        <p>
         *        For more information about creating DNS records using DKIM tokens, go to the <a
         *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES
         *        Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dkimTokens(Collection<String> dkimTokens);

        /**
         * <p>
         * A set of character strings that represent the domain's identity. Using these tokens, you will need to create
         * DNS CNAME records that point to DKIM public keys hosted by Amazon SES. Amazon Web Services will eventually
         * detect that you have updated your DNS records; this detection process may take up to 72 hours. Upon
         * successful detection, Amazon SES will be able to DKIM-sign email originating from that domain. (This only
         * applies to domain identities, not email address identities.)
         * </p>
         * <p>
         * For more information about creating DNS records using DKIM tokens, go to the <a
         * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer
         * Guide</a>.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDkimTokens(java.util.Collection)} or {@link #withDkimTokens(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param dkimTokens
         *        A set of character strings that represent the domain's identity. Using these tokens, you will need to
         *        create DNS CNAME records that point to DKIM public keys hosted by Amazon SES. Amazon Web Services will
         *        eventually detect that you have updated your DNS records; this detection process may take up to 72
         *        hours. Upon successful detection, Amazon SES will be able to DKIM-sign email originating from that
         *        domain. (This only applies to domain identities, not email address identities.)</p>
         *        <p>
         *        For more information about creating DNS records using DKIM tokens, go to the <a
         *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES
         *        Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dkimTokens(String... dkimTokens);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean dkimEnabled;

        private String dkimVerificationStatus;

        private List<String> dkimTokens = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityDkimAttributes model) {
            setDkimEnabled(model.dkimEnabled);
            setDkimVerificationStatus(model.dkimVerificationStatus);
            setDkimTokens(model.dkimTokens);
        }

        public final Boolean getDkimEnabled() {
            return dkimEnabled;
        }

        @Override
        public final Builder dkimEnabled(Boolean dkimEnabled) {
            this.dkimEnabled = dkimEnabled;
            return this;
        }

        public final void setDkimEnabled(Boolean dkimEnabled) {
            this.dkimEnabled = dkimEnabled;
        }

        public final String getDkimVerificationStatus() {
            return dkimVerificationStatus;
        }

        @Override
        public final Builder dkimVerificationStatus(String dkimVerificationStatus) {
            this.dkimVerificationStatus = dkimVerificationStatus;
            return this;
        }

        @Override
        public final Builder dkimVerificationStatus(VerificationStatus dkimVerificationStatus) {
            this.dkimVerificationStatus(dkimVerificationStatus.toString());
            return this;
        }

        public final void setDkimVerificationStatus(String dkimVerificationStatus) {
            this.dkimVerificationStatus = dkimVerificationStatus;
        }

        public final void setDkimVerificationStatus(VerificationStatus dkimVerificationStatus) {
            this.dkimVerificationStatus(dkimVerificationStatus.toString());
        }

        public final Collection<String> getDkimTokens() {
            return dkimTokens;
        }

        @Override
        public final Builder dkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dkimTokens(String... dkimTokens) {
            if (this.dkimTokens == null) {
                this.dkimTokens = new SdkInternalList<>(dkimTokens.length);
            }
            for (String e : dkimTokens) {
                this.dkimTokens.add(e);
            }
            return this;
        }

        public final void setDkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
        }

        @SafeVarargs
        public final void setDkimTokens(String... dkimTokens) {
            if (this.dkimTokens == null) {
                this.dkimTokens = new SdkInternalList<>(dkimTokens.length);
            }
            for (String e : dkimTokens) {
                this.dkimTokens.add(e);
            }
        }

        @Override
        public IdentityDkimAttributes build() {
            return new IdentityDkimAttributes(this);
        }
    }
}
