/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When included in a receipt rule, this action calls an AWS Lambda function and, optionally, publishes a notification
 * to Amazon Simple Notification Service (Amazon SNS).
 * </p>
 * <p>
 * To enable Amazon SES to call your AWS Lambda function or to publish to an Amazon SNS topic of another account, Amazon
 * SES must have permission to access those resources. For information about giving permissions, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 * <p>
 * For information about using AWS Lambda actions in receipt rules, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-lambda.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LambdaAction implements ToCopyableBuilder<LambdaAction.Builder, LambdaAction> {
    private final String topicArn;

    private final String functionArn;

    private final String invocationType;

    private LambdaAction(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.functionArn = builder.functionArn;
        this.invocationType = builder.invocationType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is taken. An example of
     * an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
     * Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS
     * Developer Guide</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is taken. An
     *         example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more
     *         information about Amazon SNS topics, see the <a
     *         href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Lambda function. An example of an AWS Lambda function ARN is
     * <code>arn:aws:lambda:us-west-2:account-id:function:MyFunction</code>. For more information about AWS Lambda, see
     * the <a href="http://docs.aws.amazon.com/lambda/latest/dg/welcome.html">AWS Lambda Developer Guide</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Lambda function. An example of an AWS Lambda function ARN is
     *         <code>arn:aws:lambda:us-west-2:account-id:function:MyFunction</code>. For more information about AWS
     *         Lambda, see the <a href="http://docs.aws.amazon.com/lambda/latest/dg/welcome.html">AWS Lambda Developer
     *         Guide</a>.
     */
    public String functionArn() {
        return functionArn;
    }

    /**
     * <p>
     * The invocation type of the AWS Lambda function. An invocation type of <code>RequestResponse</code> means that the
     * execution of the function will immediately result in a response, and a value of <code>Event</code> means that the
     * function will be invoked asynchronously. The default value is <code>Event</code>. For information about AWS
     * Lambda invocation types, see the <a href="http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda
     * Developer Guide</a>.
     * </p>
     * <important>
     * <p>
     * There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use <code>Event</code>
     * invocation in most cases. Use <code>RequestResponse</code> only when you want to make a mail flow decision, such
     * as whether to stop the receipt rule or the receipt rule set.
     * </p>
     * </important>
     * 
     * @return The invocation type of the AWS Lambda function. An invocation type of <code>RequestResponse</code> means
     *         that the execution of the function will immediately result in a response, and a value of
     *         <code>Event</code> means that the function will be invoked asynchronously. The default value is
     *         <code>Event</code>. For information about AWS Lambda invocation types, see the <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a>.</p>
     *         <important>
     *         <p>
     *         There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use
     *         <code>Event</code> invocation in most cases. Use <code>RequestResponse</code> only when you want to make
     *         a mail flow decision, such as whether to stop the receipt rule or the receipt rule set.
     *         </p>
     * @see InvocationType
     */
    public String invocationType() {
        return invocationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((topicArn() == null) ? 0 : topicArn().hashCode());
        hashCode = 31 * hashCode + ((functionArn() == null) ? 0 : functionArn().hashCode());
        hashCode = 31 * hashCode + ((invocationType() == null) ? 0 : invocationType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaAction)) {
            return false;
        }
        LambdaAction other = (LambdaAction) obj;
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        if (other.functionArn() == null ^ this.functionArn() == null) {
            return false;
        }
        if (other.functionArn() != null && !other.functionArn().equals(this.functionArn())) {
            return false;
        }
        if (other.invocationType() == null ^ this.invocationType() == null) {
            return false;
        }
        if (other.invocationType() != null && !other.invocationType().equals(this.invocationType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (topicArn() != null) {
            sb.append("TopicArn: ").append(topicArn()).append(",");
        }
        if (functionArn() != null) {
            sb.append("FunctionArn: ").append(functionArn()).append(",");
        }
        if (invocationType() != null) {
            sb.append("InvocationType: ").append(invocationType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, LambdaAction> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is taken. An example
         * of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information
         * about Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon
         * SNS Developer Guide</a>.
         * </p>
         * 
         * @param topicArn
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is taken. An
         *        example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For
         *        more information about Amazon SNS topics, see the <a
         *        href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Lambda function. An example of an AWS Lambda function ARN is
         * <code>arn:aws:lambda:us-west-2:account-id:function:MyFunction</code>. For more information about AWS Lambda,
         * see the <a href="http://docs.aws.amazon.com/lambda/latest/dg/welcome.html">AWS Lambda Developer Guide</a>.
         * </p>
         * 
         * @param functionArn
         *        The Amazon Resource Name (ARN) of the AWS Lambda function. An example of an AWS Lambda function ARN is
         *        <code>arn:aws:lambda:us-west-2:account-id:function:MyFunction</code>. For more information about AWS
         *        Lambda, see the <a href="http://docs.aws.amazon.com/lambda/latest/dg/welcome.html">AWS Lambda
         *        Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        /**
         * <p>
         * The invocation type of the AWS Lambda function. An invocation type of <code>RequestResponse</code> means that
         * the execution of the function will immediately result in a response, and a value of <code>Event</code> means
         * that the function will be invoked asynchronously. The default value is <code>Event</code>. For information
         * about AWS Lambda invocation types, see the <a
         * href="http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a>.
         * </p>
         * <important>
         * <p>
         * There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use <code>Event</code>
         * invocation in most cases. Use <code>RequestResponse</code> only when you want to make a mail flow decision,
         * such as whether to stop the receipt rule or the receipt rule set.
         * </p>
         * </important>
         * 
         * @param invocationType
         *        The invocation type of the AWS Lambda function. An invocation type of <code>RequestResponse</code>
         *        means that the execution of the function will immediately result in a response, and a value of
         *        <code>Event</code> means that the function will be invoked asynchronously. The default value is
         *        <code>Event</code>. For information about AWS Lambda invocation types, see the <a
         *        href="http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a>.</p>
         *        <important>
         *        <p>
         *        There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use
         *        <code>Event</code> invocation in most cases. Use <code>RequestResponse</code> only when you want to
         *        make a mail flow decision, such as whether to stop the receipt rule or the receipt rule set.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvocationType
         */
        Builder invocationType(String invocationType);

        /**
         * <p>
         * The invocation type of the AWS Lambda function. An invocation type of <code>RequestResponse</code> means that
         * the execution of the function will immediately result in a response, and a value of <code>Event</code> means
         * that the function will be invoked asynchronously. The default value is <code>Event</code>. For information
         * about AWS Lambda invocation types, see the <a
         * href="http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a>.
         * </p>
         * <important>
         * <p>
         * There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use <code>Event</code>
         * invocation in most cases. Use <code>RequestResponse</code> only when you want to make a mail flow decision,
         * such as whether to stop the receipt rule or the receipt rule set.
         * </p>
         * </important>
         * 
         * @param invocationType
         *        The invocation type of the AWS Lambda function. An invocation type of <code>RequestResponse</code>
         *        means that the execution of the function will immediately result in a response, and a value of
         *        <code>Event</code> means that the function will be invoked asynchronously. The default value is
         *        <code>Event</code>. For information about AWS Lambda invocation types, see the <a
         *        href="http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html">AWS Lambda Developer Guide</a>.</p>
         *        <important>
         *        <p>
         *        There is a 30-second timeout on <code>RequestResponse</code> invocations. You should use
         *        <code>Event</code> invocation in most cases. Use <code>RequestResponse</code> only when you want to
         *        make a mail flow decision, such as whether to stop the receipt rule or the receipt rule set.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvocationType
         */
        Builder invocationType(InvocationType invocationType);
    }

    private static final class BuilderImpl implements Builder {
        private String topicArn;

        private String functionArn;

        private String invocationType;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaAction model) {
            setTopicArn(model.topicArn);
            setFunctionArn(model.functionArn);
            setInvocationType(model.invocationType);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public final String getInvocationType() {
            return invocationType;
        }

        @Override
        public final Builder invocationType(String invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        @Override
        public final Builder invocationType(InvocationType invocationType) {
            this.invocationType(invocationType.toString());
            return this;
        }

        public final void setInvocationType(String invocationType) {
            this.invocationType = invocationType;
        }

        public final void setInvocationType(InvocationType invocationType) {
            this.invocationType(invocationType.toString());
        }

        @Override
        public LambdaAction build() {
            return new LambdaAction(this);
        }
    }
}
