/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to list the receipt rule sets that exist under your AWS account. You use receipt rule sets to
 * receive email with Amazon SES. For more information, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListReceiptRuleSetsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListReceiptRuleSetsRequest.Builder, ListReceiptRuleSetsRequest> {
    private final String nextToken;

    private ListReceiptRuleSetsRequest(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A token returned from a previous call to <code>ListReceiptRuleSets</code> to indicate the position in the receipt
     * rule set list.
     * </p>
     * 
     * @return A token returned from a previous call to <code>ListReceiptRuleSets</code> to indicate the position in the
     *         receipt rule set list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReceiptRuleSetsRequest)) {
            return false;
        }
        ListReceiptRuleSetsRequest other = (ListReceiptRuleSetsRequest) obj;
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListReceiptRuleSetsRequest> {
        /**
         * <p>
         * A token returned from a previous call to <code>ListReceiptRuleSets</code> to indicate the position in the
         * receipt rule set list.
         * </p>
         * 
         * @param nextToken
         *        A token returned from a previous call to <code>ListReceiptRuleSets</code> to indicate the position in
         *        the receipt rule set list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReceiptRuleSetsRequest model) {
            setNextToken(model.nextToken);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListReceiptRuleSetsRequest build() {
            return new ListReceiptRuleSetsRequest(this);
        }
    }
}
