/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that the provided receipt rule set does not exist.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RuleSetDoesNotExistException extends SESException implements
        ToCopyableBuilder<RuleSetDoesNotExistException.Builder, RuleSetDoesNotExistException> {
    private final String name;

    private RuleSetDoesNotExistException(BuilderImpl builder) {
        super(builder.message);
        this.name = builder.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     *
     * @return
     */
    public String name() {
        return name;
    }

    public interface Builder extends CopyableBuilder<Builder, RuleSetDoesNotExistException> {
        /**
         *
         * @param name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        Builder message(String message);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleSetDoesNotExistException model) {
            setName(model.name);
            this.message = model.getMessage();
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public RuleSetDoesNotExistException build() {
            return new RuleSetDoesNotExistException(this);
        }
    }
}
