/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to enable or disable the Amazon SES custom MAIL FROM domain setup for a verified identity. For
 * information about using a custom MAIL FROM domain, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SetIdentityMailFromDomainRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SetIdentityMailFromDomainRequest.Builder, SetIdentityMailFromDomainRequest> {
    private final String identity;

    private final String mailFromDomain;

    private final String behaviorOnMXFailure;

    private SetIdentityMailFromDomainRequest(BuilderImpl builder) {
        this.identity = builder.identity;
        this.mailFromDomain = builder.mailFromDomain;
        this.behaviorOnMXFailure = builder.behaviorOnMXFailure;
    }

    /**
     * <p>
     * The verified identity for which you want to enable or disable the specified custom MAIL FROM domain.
     * </p>
     * 
     * @return The verified identity for which you want to enable or disable the specified custom MAIL FROM domain.
     */
    public String identity() {
        return identity;
    }

    /**
     * <p>
     * The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must 1) be a
     * subdomain of the verified identity, 2) not be used in a "From" address if the MAIL FROM domain is the destination
     * of email feedback forwarding (for more information, see the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>), and
     * 3) not be used to receive emails. A value of <code>null</code> disables the custom MAIL FROM setting for the
     * identity.
     * </p>
     * 
     * @return The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must 1) be a
     *         subdomain of the verified identity, 2) not be used in a "From" address if the MAIL FROM domain is the
     *         destination of email feedback forwarding (for more information, see the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer
     *         Guide</a>), and 3) not be used to receive emails. A value of <code>null</code> disables the custom MAIL
     *         FROM setting for the identity.
     */
    public String mailFromDomain() {
        return mailFromDomain;
    }

    /**
     * <p>
     * The action that you want Amazon SES to take if it cannot successfully read the required MX record when you send
     * an email. If you choose <code>UseDefaultValue</code>, Amazon SES will use amazonses.com (or a subdomain of that)
     * as the MAIL FROM domain. If you choose <code>RejectMessage</code>, Amazon SES will return a
     * <code>MailFromDomainNotVerified</code> error and not send the email.
     * </p>
     * <p>
     * The action specified in <code>BehaviorOnMXFailure</code> is taken when the custom MAIL FROM domain setup is in
     * the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.
     * </p>
     * 
     * @return The action that you want Amazon SES to take if it cannot successfully read the required MX record when
     *         you send an email. If you choose <code>UseDefaultValue</code>, Amazon SES will use amazonses.com (or a
     *         subdomain of that) as the MAIL FROM domain. If you choose <code>RejectMessage</code>, Amazon SES will
     *         return a <code>MailFromDomainNotVerified</code> error and not send the email.</p>
     *         <p>
     *         The action specified in <code>BehaviorOnMXFailure</code> is taken when the custom MAIL FROM domain setup
     *         is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.
     * @see BehaviorOnMXFailure
     */
    public String behaviorOnMXFailure() {
        return behaviorOnMXFailure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identity() == null) ? 0 : identity().hashCode());
        hashCode = 31 * hashCode + ((mailFromDomain() == null) ? 0 : mailFromDomain().hashCode());
        hashCode = 31 * hashCode + ((behaviorOnMXFailure() == null) ? 0 : behaviorOnMXFailure().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIdentityMailFromDomainRequest)) {
            return false;
        }
        SetIdentityMailFromDomainRequest other = (SetIdentityMailFromDomainRequest) obj;
        if (other.identity() == null ^ this.identity() == null) {
            return false;
        }
        if (other.identity() != null && !other.identity().equals(this.identity())) {
            return false;
        }
        if (other.mailFromDomain() == null ^ this.mailFromDomain() == null) {
            return false;
        }
        if (other.mailFromDomain() != null && !other.mailFromDomain().equals(this.mailFromDomain())) {
            return false;
        }
        if (other.behaviorOnMXFailure() == null ^ this.behaviorOnMXFailure() == null) {
            return false;
        }
        if (other.behaviorOnMXFailure() != null && !other.behaviorOnMXFailure().equals(this.behaviorOnMXFailure())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identity() != null) {
            sb.append("Identity: ").append(identity()).append(",");
        }
        if (mailFromDomain() != null) {
            sb.append("MailFromDomain: ").append(mailFromDomain()).append(",");
        }
        if (behaviorOnMXFailure() != null) {
            sb.append("BehaviorOnMXFailure: ").append(behaviorOnMXFailure()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SetIdentityMailFromDomainRequest> {
        /**
         * <p>
         * The verified identity for which you want to enable or disable the specified custom MAIL FROM domain.
         * </p>
         * 
         * @param identity
         *        The verified identity for which you want to enable or disable the specified custom MAIL FROM domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);

        /**
         * <p>
         * The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must 1) be a
         * subdomain of the verified identity, 2) not be used in a "From" address if the MAIL FROM domain is the
         * destination of email feedback forwarding (for more information, see the <a
         * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer Guide</a>),
         * and 3) not be used to receive emails. A value of <code>null</code> disables the custom MAIL FROM setting for
         * the identity.
         * </p>
         * 
         * @param mailFromDomain
         *        The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must 1)
         *        be a subdomain of the verified identity, 2) not be used in a "From" address if the MAIL FROM domain is
         *        the destination of email feedback forwarding (for more information, see the <a
         *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html">Amazon SES Developer
         *        Guide</a>), and 3) not be used to receive emails. A value of <code>null</code> disables the custom
         *        MAIL FROM setting for the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailFromDomain(String mailFromDomain);

        /**
         * <p>
         * The action that you want Amazon SES to take if it cannot successfully read the required MX record when you
         * send an email. If you choose <code>UseDefaultValue</code>, Amazon SES will use amazonses.com (or a subdomain
         * of that) as the MAIL FROM domain. If you choose <code>RejectMessage</code>, Amazon SES will return a
         * <code>MailFromDomainNotVerified</code> error and not send the email.
         * </p>
         * <p>
         * The action specified in <code>BehaviorOnMXFailure</code> is taken when the custom MAIL FROM domain setup is
         * in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.
         * </p>
         * 
         * @param behaviorOnMXFailure
         *        The action that you want Amazon SES to take if it cannot successfully read the required MX record when
         *        you send an email. If you choose <code>UseDefaultValue</code>, Amazon SES will use amazonses.com (or a
         *        subdomain of that) as the MAIL FROM domain. If you choose <code>RejectMessage</code>, Amazon SES will
         *        return a <code>MailFromDomainNotVerified</code> error and not send the email.</p>
         *        <p>
         *        The action specified in <code>BehaviorOnMXFailure</code> is taken when the custom MAIL FROM domain
         *        setup is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorOnMXFailure
         */
        Builder behaviorOnMXFailure(String behaviorOnMXFailure);

        /**
         * <p>
         * The action that you want Amazon SES to take if it cannot successfully read the required MX record when you
         * send an email. If you choose <code>UseDefaultValue</code>, Amazon SES will use amazonses.com (or a subdomain
         * of that) as the MAIL FROM domain. If you choose <code>RejectMessage</code>, Amazon SES will return a
         * <code>MailFromDomainNotVerified</code> error and not send the email.
         * </p>
         * <p>
         * The action specified in <code>BehaviorOnMXFailure</code> is taken when the custom MAIL FROM domain setup is
         * in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.
         * </p>
         * 
         * @param behaviorOnMXFailure
         *        The action that you want Amazon SES to take if it cannot successfully read the required MX record when
         *        you send an email. If you choose <code>UseDefaultValue</code>, Amazon SES will use amazonses.com (or a
         *        subdomain of that) as the MAIL FROM domain. If you choose <code>RejectMessage</code>, Amazon SES will
         *        return a <code>MailFromDomainNotVerified</code> error and not send the email.</p>
         *        <p>
         *        The action specified in <code>BehaviorOnMXFailure</code> is taken when the custom MAIL FROM domain
         *        setup is in the <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorOnMXFailure
         */
        Builder behaviorOnMXFailure(BehaviorOnMXFailure behaviorOnMXFailure);
    }

    private static final class BuilderImpl implements Builder {
        private String identity;

        private String mailFromDomain;

        private String behaviorOnMXFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(SetIdentityMailFromDomainRequest model) {
            setIdentity(model.identity);
            setMailFromDomain(model.mailFromDomain);
            setBehaviorOnMXFailure(model.behaviorOnMXFailure);
        }

        public final String getIdentity() {
            return identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final String getMailFromDomain() {
            return mailFromDomain;
        }

        @Override
        public final Builder mailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
            return this;
        }

        public final void setMailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
        }

        public final String getBehaviorOnMXFailure() {
            return behaviorOnMXFailure;
        }

        @Override
        public final Builder behaviorOnMXFailure(String behaviorOnMXFailure) {
            this.behaviorOnMXFailure = behaviorOnMXFailure;
            return this;
        }

        @Override
        public final Builder behaviorOnMXFailure(BehaviorOnMXFailure behaviorOnMXFailure) {
            this.behaviorOnMXFailure(behaviorOnMXFailure.toString());
            return this;
        }

        public final void setBehaviorOnMXFailure(String behaviorOnMXFailure) {
            this.behaviorOnMXFailure = behaviorOnMXFailure;
        }

        public final void setBehaviorOnMXFailure(BehaviorOnMXFailure behaviorOnMXFailure) {
            this.behaviorOnMXFailure(behaviorOnMXFailure.toString());
        }

        @Override
        public SetIdentityMailFromDomainRequest build() {
            return new SetIdentityMailFromDomainRequest(this);
        }
    }
}
