/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * CreateConfigurationSetEventDestinationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateConfigurationSetEventDestinationRequestMarshaller implements
        Marshaller<Request<CreateConfigurationSetEventDestinationRequest>, CreateConfigurationSetEventDestinationRequest> {

    public Request<CreateConfigurationSetEventDestinationRequest> marshall(
            CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest) {

        if (createConfigurationSetEventDestinationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateConfigurationSetEventDestinationRequest> request = new DefaultRequest<CreateConfigurationSetEventDestinationRequest>(
                createConfigurationSetEventDestinationRequest, "SESClient");
        request.addParameter("Action", "CreateConfigurationSetEventDestination");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (createConfigurationSetEventDestinationRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName",
                    StringUtils.fromString(createConfigurationSetEventDestinationRequest.configurationSetName()));
        }

        EventDestination eventDestination = createConfigurationSetEventDestinationRequest.eventDestination();
        if (eventDestination != null) {

            if (eventDestination.name() != null) {
                request.addParameter("EventDestination.Name", StringUtils.fromString(eventDestination.name()));
            }

            if (eventDestination.enabled() != null) {
                request.addParameter("EventDestination.Enabled", StringUtils.fromBoolean(eventDestination.enabled()));
            }

            software.amazon.awssdk.runtime.SdkInternalList<String> matchingEventTypesList = (software.amazon.awssdk.runtime.SdkInternalList<String>) eventDestination
                    .matchingEventTypes();
            if (!matchingEventTypesList.isEmpty() || !matchingEventTypesList.isAutoConstruct()) {
                int matchingEventTypesListIndex = 1;

                for (String matchingEventTypesListValue : matchingEventTypesList) {
                    if (matchingEventTypesListValue != null) {
                        request.addParameter("EventDestination.MatchingEventTypes.member." + matchingEventTypesListIndex,
                                StringUtils.fromString(matchingEventTypesListValue));
                    }
                    matchingEventTypesListIndex++;
                }
            }

            KinesisFirehoseDestination kinesisFirehoseDestination = eventDestination.kinesisFirehoseDestination();
            if (kinesisFirehoseDestination != null) {

                if (kinesisFirehoseDestination.iamRoleARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.IAMRoleARN",
                            StringUtils.fromString(kinesisFirehoseDestination.iamRoleARN()));
                }

                if (kinesisFirehoseDestination.deliveryStreamARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.DeliveryStreamARN",
                            StringUtils.fromString(kinesisFirehoseDestination.deliveryStreamARN()));
                }
            }

            CloudWatchDestination cloudWatchDestination = eventDestination.cloudWatchDestination();
            if (cloudWatchDestination != null) {

                software.amazon.awssdk.runtime.SdkInternalList<CloudWatchDimensionConfiguration> dimensionConfigurationsList = (software.amazon.awssdk.runtime.SdkInternalList<CloudWatchDimensionConfiguration>) cloudWatchDestination
                        .dimensionConfigurations();
                if (!dimensionConfigurationsList.isEmpty() || !dimensionConfigurationsList.isAutoConstruct()) {
                    int dimensionConfigurationsListIndex = 1;

                    for (CloudWatchDimensionConfiguration dimensionConfigurationsListValue : dimensionConfigurationsList) {

                        if (dimensionConfigurationsListValue.dimensionName() != null) {
                            request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member."
                                    + dimensionConfigurationsListIndex + ".DimensionName",
                                    StringUtils.fromString(dimensionConfigurationsListValue.dimensionName()));
                        }

                        if (dimensionConfigurationsListValue.dimensionValueSource() != null) {
                            request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member."
                                    + dimensionConfigurationsListIndex + ".DimensionValueSource",
                                    StringUtils.fromString(dimensionConfigurationsListValue.dimensionValueSource()));
                        }

                        if (dimensionConfigurationsListValue.defaultDimensionValue() != null) {
                            request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member."
                                    + dimensionConfigurationsListIndex + ".DefaultDimensionValue",
                                    StringUtils.fromString(dimensionConfigurationsListValue.defaultDimensionValue()));
                        }
                        dimensionConfigurationsListIndex++;
                    }
                }
            }
        }

        return request;
    }

}
