/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * DescribeConfigurationSetRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeConfigurationSetRequestMarshaller implements
        Marshaller<Request<DescribeConfigurationSetRequest>, DescribeConfigurationSetRequest> {

    public Request<DescribeConfigurationSetRequest> marshall(DescribeConfigurationSetRequest describeConfigurationSetRequest) {

        if (describeConfigurationSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeConfigurationSetRequest> request = new DefaultRequest<DescribeConfigurationSetRequest>(
                describeConfigurationSetRequest, "SESClient");
        request.addParameter("Action", "DescribeConfigurationSet");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (describeConfigurationSetRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName",
                    StringUtils.fromString(describeConfigurationSetRequest.configurationSetName()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<String> configurationSetAttributeNamesList = (software.amazon.awssdk.runtime.SdkInternalList<String>) describeConfigurationSetRequest
                .configurationSetAttributeNames();
        if (!configurationSetAttributeNamesList.isEmpty() || !configurationSetAttributeNamesList.isAutoConstruct()) {
            int configurationSetAttributeNamesListIndex = 1;

            for (String configurationSetAttributeNamesListValue : configurationSetAttributeNamesList) {
                if (configurationSetAttributeNamesListValue != null) {
                    request.addParameter("ConfigurationSetAttributeNames.member." + configurationSetAttributeNamesListIndex,
                            StringUtils.fromString(configurationSetAttributeNamesListValue));
                }
                configurationSetAttributeNamesListIndex++;
            }
        }

        return request;
    }

}
