/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * GetIdentityPoliciesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetIdentityPoliciesRequestMarshaller implements
        Marshaller<Request<GetIdentityPoliciesRequest>, GetIdentityPoliciesRequest> {

    public Request<GetIdentityPoliciesRequest> marshall(GetIdentityPoliciesRequest getIdentityPoliciesRequest) {

        if (getIdentityPoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<GetIdentityPoliciesRequest> request = new DefaultRequest<GetIdentityPoliciesRequest>(getIdentityPoliciesRequest,
                "SESClient");
        request.addParameter("Action", "GetIdentityPolicies");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (getIdentityPoliciesRequest.identity() != null) {
            request.addParameter("Identity", StringUtils.fromString(getIdentityPoliciesRequest.identity()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<String> policyNamesList = (software.amazon.awssdk.runtime.SdkInternalList<String>) getIdentityPoliciesRequest
                .policyNames();
        if (!policyNamesList.isEmpty() || !policyNamesList.isAutoConstruct()) {
            int policyNamesListIndex = 1;

            for (String policyNamesListValue : policyNamesList) {
                if (policyNamesListValue != null) {
                    request.addParameter("PolicyNames.member." + policyNamesListIndex,
                            StringUtils.fromString(policyNamesListValue));
                }
                policyNamesListIndex++;
            }
        }

        return request;
    }

}
