/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * SendRawEmailRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SendRawEmailRequestMarshaller implements Marshaller<Request<SendRawEmailRequest>, SendRawEmailRequest> {

    public Request<SendRawEmailRequest> marshall(SendRawEmailRequest sendRawEmailRequest) {

        if (sendRawEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<SendRawEmailRequest> request = new DefaultRequest<SendRawEmailRequest>(sendRawEmailRequest, "SESClient");
        request.addParameter("Action", "SendRawEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (sendRawEmailRequest.source() != null) {
            request.addParameter("Source", StringUtils.fromString(sendRawEmailRequest.source()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<String> destinationsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) sendRawEmailRequest
                .destinations();
        if (!destinationsList.isEmpty() || !destinationsList.isAutoConstruct()) {
            int destinationsListIndex = 1;

            for (String destinationsListValue : destinationsList) {
                if (destinationsListValue != null) {
                    request.addParameter("Destinations.member." + destinationsListIndex,
                            StringUtils.fromString(destinationsListValue));
                }
                destinationsListIndex++;
            }
        }

        RawMessage rawMessage = sendRawEmailRequest.rawMessage();
        if (rawMessage != null) {

            if (rawMessage.data() != null) {
                request.addParameter("RawMessage.Data", StringUtils.fromByteBuffer(rawMessage.data()));
            }
        }

        if (sendRawEmailRequest.fromArn() != null) {
            request.addParameter("FromArn", StringUtils.fromString(sendRawEmailRequest.fromArn()));
        }

        if (sendRawEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString(sendRawEmailRequest.sourceArn()));
        }

        if (sendRawEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString(sendRawEmailRequest.returnPathArn()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<MessageTag> tagsList = (software.amazon.awssdk.runtime.SdkInternalList<MessageTag>) sendRawEmailRequest
                .tags();
        if (!tagsList.isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;

            for (MessageTag tagsListValue : tagsList) {

                if (tagsListValue.name() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Name", StringUtils.fromString(tagsListValue.name()));
                }

                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.value()));
                }
                tagsListIndex++;
            }
        }

        if (sendRawEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString(sendRawEmailRequest.configurationSetName()));
        }

        return request;
    }

}
