/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ses.model.VerificationStatus;
import software.amazon.awssdk.services.ses.model.VerificationTokenListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IdentityDkimAttributes
implements ToCopyableBuilder<Builder, IdentityDkimAttributes> {
    private final Boolean dkimEnabled;
    private final String dkimVerificationStatus;
    private final List<String> dkimTokens;

    private IdentityDkimAttributes(BuilderImpl builder) {
        this.dkimEnabled = builder.dkimEnabled;
        this.dkimVerificationStatus = builder.dkimVerificationStatus;
        this.dkimTokens = builder.dkimTokens;
    }

    public Boolean dkimEnabled() {
        return this.dkimEnabled;
    }

    public String dkimVerificationStatus() {
        return this.dkimVerificationStatus;
    }

    public List<String> dkimTokens() {
        return this.dkimTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dkimEnabled() == null ? 0 : this.dkimEnabled().hashCode());
        hashCode = 31 * hashCode + (this.dkimVerificationStatus() == null ? 0 : this.dkimVerificationStatus().hashCode());
        hashCode = 31 * hashCode + (this.dkimTokens() == null ? 0 : this.dkimTokens().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityDkimAttributes)) {
            return false;
        }
        IdentityDkimAttributes other = (IdentityDkimAttributes)obj;
        if (other.dkimEnabled() == null ^ this.dkimEnabled() == null) {
            return false;
        }
        if (other.dkimEnabled() != null && !other.dkimEnabled().equals(this.dkimEnabled())) {
            return false;
        }
        if (other.dkimVerificationStatus() == null ^ this.dkimVerificationStatus() == null) {
            return false;
        }
        if (other.dkimVerificationStatus() != null && !other.dkimVerificationStatus().equals(this.dkimVerificationStatus())) {
            return false;
        }
        if (other.dkimTokens() == null ^ this.dkimTokens() == null) {
            return false;
        }
        return other.dkimTokens() == null || other.dkimTokens().equals(this.dkimTokens());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dkimEnabled() != null) {
            sb.append("DkimEnabled: ").append(this.dkimEnabled()).append(",");
        }
        if (this.dkimVerificationStatus() != null) {
            sb.append("DkimVerificationStatus: ").append(this.dkimVerificationStatus()).append(",");
        }
        if (this.dkimTokens() != null) {
            sb.append("DkimTokens: ").append(this.dkimTokens()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean dkimEnabled;
        private String dkimVerificationStatus;
        private List<String> dkimTokens = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityDkimAttributes model) {
            this.setDkimEnabled(model.dkimEnabled);
            this.setDkimVerificationStatus(model.dkimVerificationStatus);
            this.setDkimTokens(model.dkimTokens);
        }

        public final Boolean getDkimEnabled() {
            return this.dkimEnabled;
        }

        @Override
        public final Builder dkimEnabled(Boolean dkimEnabled) {
            this.dkimEnabled = dkimEnabled;
            return this;
        }

        public final void setDkimEnabled(Boolean dkimEnabled) {
            this.dkimEnabled = dkimEnabled;
        }

        public final String getDkimVerificationStatus() {
            return this.dkimVerificationStatus;
        }

        @Override
        public final Builder dkimVerificationStatus(String dkimVerificationStatus) {
            this.dkimVerificationStatus = dkimVerificationStatus;
            return this;
        }

        @Override
        public final Builder dkimVerificationStatus(VerificationStatus dkimVerificationStatus) {
            this.dkimVerificationStatus(dkimVerificationStatus.toString());
            return this;
        }

        public final void setDkimVerificationStatus(String dkimVerificationStatus) {
            this.dkimVerificationStatus = dkimVerificationStatus;
        }

        public final void setDkimVerificationStatus(VerificationStatus dkimVerificationStatus) {
            this.dkimVerificationStatus(dkimVerificationStatus.toString());
        }

        public final Collection<String> getDkimTokens() {
            return this.dkimTokens;
        }

        @Override
        public final Builder dkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dkimTokens(String ... dkimTokens) {
            if (this.dkimTokens == null) {
                this.dkimTokens = new SdkInternalList(dkimTokens.length);
            }
            for (String e : dkimTokens) {
                this.dkimTokens.add(e);
            }
            return this;
        }

        public final void setDkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
        }

        @SafeVarargs
        public final void setDkimTokens(String ... dkimTokens) {
            if (this.dkimTokens == null) {
                this.dkimTokens = new SdkInternalList(dkimTokens.length);
            }
            for (String e : dkimTokens) {
                this.dkimTokens.add(e);
            }
        }

        public IdentityDkimAttributes build() {
            return new IdentityDkimAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IdentityDkimAttributes> {
        public Builder dkimEnabled(Boolean var1);

        public Builder dkimVerificationStatus(String var1);

        public Builder dkimVerificationStatus(VerificationStatus var1);

        public Builder dkimTokens(Collection<String> var1);

        public Builder dkimTokens(String ... var1);
    }
}

