/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import software.amazon.awssdk.services.ses.model.SNSActionEncoding;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SNSAction
implements ToCopyableBuilder<Builder, SNSAction> {
    private final String topicArn;
    private final String encoding;

    private SNSAction(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.encoding = builder.encoding;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public String encoding() {
        return this.encoding;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.topicArn() == null ? 0 : this.topicArn().hashCode());
        hashCode = 31 * hashCode + (this.encoding() == null ? 0 : this.encoding().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SNSAction)) {
            return false;
        }
        SNSAction other = (SNSAction)obj;
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        if (other.encoding() == null ^ this.encoding() == null) {
            return false;
        }
        return other.encoding() == null || other.encoding().equals(this.encoding());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.topicArn() != null) {
            sb.append("TopicArn: ").append(this.topicArn()).append(",");
        }
        if (this.encoding() != null) {
            sb.append("Encoding: ").append(this.encoding()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String topicArn;
        private String encoding;

        private BuilderImpl() {
        }

        private BuilderImpl(SNSAction model) {
            this.setTopicArn(model.topicArn);
            this.setEncoding(model.encoding);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getEncoding() {
            return this.encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public final Builder encoding(SNSActionEncoding encoding) {
            this.encoding(encoding.toString());
            return this;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public final void setEncoding(SNSActionEncoding encoding) {
            this.encoding(encoding.toString());
        }

        public SNSAction build() {
            return new SNSAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SNSAction> {
        public Builder topicArn(String var1);

        public Builder encoding(String var1);

        public Builder encoding(SNSActionEncoding var1);
    }
}

