/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.DescribeReceiptRuleRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeReceiptRuleRequestMarshaller
implements Marshaller<Request<DescribeReceiptRuleRequest>, DescribeReceiptRuleRequest> {
    public Request<DescribeReceiptRuleRequest> marshall(DescribeReceiptRuleRequest describeReceiptRuleRequest) {
        if (describeReceiptRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeReceiptRuleRequest, "SESClient");
        request.addParameter("Action", "DescribeReceiptRule");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeReceiptRuleRequest.ruleSetName() != null) {
            request.addParameter("RuleSetName", StringUtils.fromString((String)describeReceiptRuleRequest.ruleSetName()));
        }
        if (describeReceiptRuleRequest.ruleName() != null) {
            request.addParameter("RuleName", StringUtils.fromString((String)describeReceiptRuleRequest.ruleName()));
        }
        return request;
    }
}

