/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.RawMessage;

public class RawMessageUnmarshaller
implements Unmarshaller<RawMessage, StaxUnmarshallerContext> {
    private static RawMessageUnmarshaller INSTANCE;

    public RawMessage unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        RawMessage.Builder rawMessage = RawMessage.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Data", targetDepth)) continue;
                rawMessage.data(SimpleTypeStaxUnmarshallers.ByteBufferUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (RawMessage)rawMessage.build();
    }

    public static RawMessageUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RawMessageUnmarshaller();
        }
        return INSTANCE;
    }
}

