/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.RawMessage;
import software.amazon.awssdk.services.ses.model.SendRawEmailRequest;
import software.amazon.awssdk.util.StringUtils;

public class SendRawEmailRequestMarshaller
implements Marshaller<Request<SendRawEmailRequest>, SendRawEmailRequest> {
    public Request<SendRawEmailRequest> marshall(SendRawEmailRequest sendRawEmailRequest) {
        SdkInternalList tagsList;
        RawMessage rawMessage;
        SdkInternalList destinationsList;
        if (sendRawEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendRawEmailRequest, "SESClient");
        request.addParameter("Action", "SendRawEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendRawEmailRequest.source() != null) {
            request.addParameter("Source", StringUtils.fromString((String)sendRawEmailRequest.source()));
        }
        if (!(destinationsList = (SdkInternalList)sendRawEmailRequest.destinations()).isEmpty() || !destinationsList.isAutoConstruct()) {
            int destinationsListIndex = 1;
            for (String destinationsListValue : destinationsList) {
                if (destinationsListValue != null) {
                    request.addParameter("Destinations.member." + destinationsListIndex, StringUtils.fromString((String)destinationsListValue));
                }
                ++destinationsListIndex;
            }
        }
        if ((rawMessage = sendRawEmailRequest.rawMessage()) != null && rawMessage.data() != null) {
            request.addParameter("RawMessage.Data", StringUtils.fromByteBuffer((ByteBuffer)rawMessage.data()));
        }
        if (sendRawEmailRequest.fromArn() != null) {
            request.addParameter("FromArn", StringUtils.fromString((String)sendRawEmailRequest.fromArn()));
        }
        if (sendRawEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString((String)sendRawEmailRequest.sourceArn()));
        }
        if (sendRawEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString((String)sendRawEmailRequest.returnPathArn()));
        }
        if (!(tagsList = (SdkInternalList)sendRawEmailRequest.tags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (MessageTag tagsListValue : tagsList) {
                if (tagsListValue.name() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Name", StringUtils.fromString((String)tagsListValue.name()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (sendRawEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)sendRawEmailRequest.configurationSetName()));
        }
        return request;
    }
}

