/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.ses.SESClient;
import software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesRequest;
import software.amazon.awssdk.services.ses.waiters.GetIdentityVerificationAttributesFunction;
import software.amazon.awssdk.services.ses.waiters.IdentityExists;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;

public class SESClientWaiters {
    private final SESClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public SESClientWaiters(SESClient client) {
        this.client = client;
    }

    public Waiter<GetIdentityVerificationAttributesRequest> identityExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetIdentityVerificationAttributesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new IdentityExists.IsSuccessMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(3))).withExecutorService(this.executorService).build();
    }
}

