/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When included in a receipt rule, this action adds a header to the received email.
 * </p>
 * <p>
 * For information about adding a header using a receipt rule, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-add-header.html">Amazon SES
 * Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AddHeaderAction implements ToCopyableBuilder<AddHeaderAction.Builder, AddHeaderAction> {
    private final String headerName;

    private final String headerValue;

    private AddHeaderAction(BuilderImpl builder) {
        this.headerName = builder.headerName;
        this.headerValue = builder.headerValue;
    }

    /**
     * <p>
     * The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of alphanumeric (a-z,
     * A-Z, 0-9) characters and dashes only.
     * </p>
     * 
     * @return The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of
     *         alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
     */
    public String headerName() {
        return headerName;
    }

    /**
     * <p>
     * Must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").
     * </p>
     * 
     * @return Must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").
     */
    public String headerValue() {
        return headerValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(headerName());
        hashCode = 31 * hashCode + Objects.hashCode(headerValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddHeaderAction)) {
            return false;
        }
        AddHeaderAction other = (AddHeaderAction) obj;
        return Objects.equals(headerName(), other.headerName()) && Objects.equals(headerValue(), other.headerValue());
    }

    @Override
    public String toString() {
        return ToString.builder("AddHeaderAction").add("HeaderName", headerName()).add("HeaderValue", headerValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HeaderName":
            return Optional.of(clazz.cast(headerName()));
        case "HeaderValue":
            return Optional.of(clazz.cast(headerValue()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AddHeaderAction> {
        /**
         * <p>
         * The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of alphanumeric
         * (a-z, A-Z, 0-9) characters and dashes only.
         * </p>
         * 
         * @param headerName
         *        The name of the header to add. Must be between 1 and 50 characters, inclusive, and consist of
         *        alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerName(String headerName);

        /**
         * <p>
         * Must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").
         * </p>
         * 
         * @param headerValue
         *        Must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerValue(String headerValue);
    }

    static final class BuilderImpl implements Builder {
        private String headerName;

        private String headerValue;

        private BuilderImpl() {
        }

        private BuilderImpl(AddHeaderAction model) {
            headerName(model.headerName);
            headerValue(model.headerValue);
        }

        public final String getHeaderName() {
            return headerName;
        }

        @Override
        public final Builder headerName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public final void setHeaderName(String headerName) {
            this.headerName = headerName;
        }

        public final String getHeaderValue() {
            return headerValue;
        }

        @Override
        public final Builder headerValue(String headerValue) {
            this.headerValue = headerValue;
            return this;
        }

        public final void setHeaderValue(String headerValue) {
            this.headerValue = headerValue;
        }

        @Override
        public AddHeaderAction build() {
            return new AddHeaderAction(this);
        }
    }
}
