/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create a configuration set. Configuration sets enable you to publish email sending events.
 * For information about using configuration sets, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateConfigurationSetRequest extends SESRequest implements
        ToCopyableBuilder<CreateConfigurationSetRequest.Builder, CreateConfigurationSetRequest> {
    private final ConfigurationSet configurationSet;

    private CreateConfigurationSetRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSet = builder.configurationSet;
    }

    /**
     * <p>
     * A data structure that contains the name of the configuration set.
     * </p>
     * 
     * @return A data structure that contains the name of the configuration set.
     */
    public ConfigurationSet configurationSet() {
        return configurationSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationSetRequest)) {
            return false;
        }
        CreateConfigurationSetRequest other = (CreateConfigurationSetRequest) obj;
        return Objects.equals(configurationSet(), other.configurationSet());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateConfigurationSetRequest").add("ConfigurationSet", configurationSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSet":
            return Optional.of(clazz.cast(configurationSet()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESRequest.Builder, CopyableBuilder<Builder, CreateConfigurationSetRequest> {
        /**
         * <p>
         * A data structure that contains the name of the configuration set.
         * </p>
         * 
         * @param configurationSet
         *        A data structure that contains the name of the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSet(ConfigurationSet configurationSet);

        /**
         * <p>
         * A data structure that contains the name of the configuration set.
         * </p>
         * This is a convenience that creates an instance of the {@link ConfigurationSet.Builder} avoiding the need to
         * create one manually via {@link ConfigurationSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationSet.Builder#build()} is called immediately and its
         * result is passed to {@link #configurationSet(ConfigurationSet)}.
         * 
         * @param configurationSet
         *        a consumer that will call methods on {@link ConfigurationSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationSet(ConfigurationSet)
         */
        default Builder configurationSet(Consumer<ConfigurationSet.Builder> configurationSet) {
            return configurationSet(ConfigurationSet.builder().apply(configurationSet).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SESRequest.BuilderImpl implements Builder {
        private ConfigurationSet configurationSet;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationSetRequest model) {
            super(model);
            configurationSet(model.configurationSet);
        }

        public final ConfigurationSet.Builder getConfigurationSet() {
            return configurationSet != null ? configurationSet.toBuilder() : null;
        }

        @Override
        public final Builder configurationSet(ConfigurationSet configurationSet) {
            this.configurationSet = configurationSet;
            return this;
        }

        public final void setConfigurationSet(ConfigurationSet.BuilderImpl configurationSet) {
            this.configurationSet = configurationSet != null ? configurationSet.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateConfigurationSetRequest build() {
            return new CreateConfigurationSetRequest(this);
        }
    }
}
