/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create a receipt rule. You use receipt rules to receive email with Amazon SES. For more
 * information, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateReceiptRuleRequest extends SESRequest implements
        ToCopyableBuilder<CreateReceiptRuleRequest.Builder, CreateReceiptRuleRequest> {
    private final String ruleSetName;

    private final String after;

    private final ReceiptRule rule;

    private CreateReceiptRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetName = builder.ruleSetName;
        this.after = builder.after;
        this.rule = builder.rule;
    }

    /**
     * <p>
     * The name of the rule set that the receipt rule will be added to.
     * </p>
     * 
     * @return The name of the rule set that the receipt rule will be added to.
     */
    public String ruleSetName() {
        return ruleSetName;
    }

    /**
     * <p>
     * The name of an existing rule after which the new rule will be placed. If this parameter is null, the new rule
     * will be inserted at the beginning of the rule list.
     * </p>
     * 
     * @return The name of an existing rule after which the new rule will be placed. If this parameter is null, the new
     *         rule will be inserted at the beginning of the rule list.
     */
    public String after() {
        return after;
    }

    /**
     * <p>
     * A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan
     * status, and TLS policy.
     * </p>
     * 
     * @return A data structure that contains the specified rule's name, actions, recipients, domains, enabled status,
     *         scan status, and TLS policy.
     */
    public ReceiptRule rule() {
        return rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(after());
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReceiptRuleRequest)) {
            return false;
        }
        CreateReceiptRuleRequest other = (CreateReceiptRuleRequest) obj;
        return Objects.equals(ruleSetName(), other.ruleSetName()) && Objects.equals(after(), other.after())
                && Objects.equals(rule(), other.rule());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateReceiptRuleRequest").add("RuleSetName", ruleSetName()).add("After", after())
                .add("Rule", rule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSetName":
            return Optional.of(clazz.cast(ruleSetName()));
        case "After":
            return Optional.of(clazz.cast(after()));
        case "Rule":
            return Optional.of(clazz.cast(rule()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESRequest.Builder, CopyableBuilder<Builder, CreateReceiptRuleRequest> {
        /**
         * <p>
         * The name of the rule set that the receipt rule will be added to.
         * </p>
         * 
         * @param ruleSetName
         *        The name of the rule set that the receipt rule will be added to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetName(String ruleSetName);

        /**
         * <p>
         * The name of an existing rule after which the new rule will be placed. If this parameter is null, the new rule
         * will be inserted at the beginning of the rule list.
         * </p>
         * 
         * @param after
         *        The name of an existing rule after which the new rule will be placed. If this parameter is null, the
         *        new rule will be inserted at the beginning of the rule list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder after(String after);

        /**
         * <p>
         * A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan
         * status, and TLS policy.
         * </p>
         * 
         * @param rule
         *        A data structure that contains the specified rule's name, actions, recipients, domains, enabled
         *        status, scan status, and TLS policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(ReceiptRule rule);

        /**
         * <p>
         * A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan
         * status, and TLS policy.
         * </p>
         * This is a convenience that creates an instance of the {@link ReceiptRule.Builder} avoiding the need to create
         * one manually via {@link ReceiptRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReceiptRule.Builder#build()} is called immediately and its result
         * is passed to {@link #rule(ReceiptRule)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link ReceiptRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(ReceiptRule)
         */
        default Builder rule(Consumer<ReceiptRule.Builder> rule) {
            return rule(ReceiptRule.builder().apply(rule).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SESRequest.BuilderImpl implements Builder {
        private String ruleSetName;

        private String after;

        private ReceiptRule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReceiptRuleRequest model) {
            super(model);
            ruleSetName(model.ruleSetName);
            after(model.after);
            rule(model.rule);
        }

        public final String getRuleSetName() {
            return ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getAfter() {
            return after;
        }

        @Override
        public final Builder after(String after) {
            this.after = after;
            return this;
        }

        public final void setAfter(String after) {
            this.after = after;
        }

        public final ReceiptRule.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        @Override
        public final Builder rule(ReceiptRule rule) {
            this.rule = rule;
            return this;
        }

        public final void setRule(ReceiptRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateReceiptRuleRequest build() {
            return new CreateReceiptRuleRequest(this);
        }
    }
}
