/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create an email template. For more information, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateTemplateRequest extends SESRequest implements
        ToCopyableBuilder<CreateTemplateRequest.Builder, CreateTemplateRequest> {
    private final Template template;

    private CreateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.template = builder.template;
    }

    /**
     * <p>
     * The content of the email, composed of a subject line, an HTML part, and a text-only part.
     * </p>
     * 
     * @return The content of the email, composed of a subject line, an HTML part, and a text-only part.
     */
    public Template template() {
        return template;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(template());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTemplateRequest)) {
            return false;
        }
        CreateTemplateRequest other = (CreateTemplateRequest) obj;
        return Objects.equals(template(), other.template());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateTemplateRequest").add("Template", template()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Template":
            return Optional.of(clazz.cast(template()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESRequest.Builder, CopyableBuilder<Builder, CreateTemplateRequest> {
        /**
         * <p>
         * The content of the email, composed of a subject line, an HTML part, and a text-only part.
         * </p>
         * 
         * @param template
         *        The content of the email, composed of a subject line, an HTML part, and a text-only part.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(Template template);

        /**
         * <p>
         * The content of the email, composed of a subject line, an HTML part, and a text-only part.
         * </p>
         * This is a convenience that creates an instance of the {@link Template.Builder} avoiding the need to create
         * one manually via {@link Template#builder()}.
         *
         * When the {@link Consumer} completes, {@link Template.Builder#build()} is called immediately and its result is
         * passed to {@link #template(Template)}.
         * 
         * @param template
         *        a consumer that will call methods on {@link Template.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #template(Template)
         */
        default Builder template(Consumer<Template.Builder> template) {
            return template(Template.builder().apply(template).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SESRequest.BuilderImpl implements Builder {
        private Template template;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTemplateRequest model) {
            super(model);
            template(model.template);
        }

        public final Template.Builder getTemplate() {
            return template != null ? template.toBuilder() : null;
        }

        @Override
        public final Builder template(Template template) {
            this.template = template;
            return this;
        }

        public final void setTemplate(Template.BuilderImpl template) {
            this.template = template != null ? template.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateTemplateRequest build() {
            return new CreateTemplateRequest(this);
        }
    }
}
