/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to delete one of your Amazon SES identities (an email address or domain).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteIdentityRequest extends SESRequest implements
        ToCopyableBuilder<DeleteIdentityRequest.Builder, DeleteIdentityRequest> {
    private final String identity;

    private DeleteIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.identity = builder.identity;
    }

    /**
     * <p>
     * The identity to be removed from the list of identities for the AWS Account.
     * </p>
     * 
     * @return The identity to be removed from the list of identities for the AWS Account.
     */
    public String identity() {
        return identity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIdentityRequest)) {
            return false;
        }
        DeleteIdentityRequest other = (DeleteIdentityRequest) obj;
        return Objects.equals(identity(), other.identity());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteIdentityRequest").add("Identity", identity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identity":
            return Optional.of(clazz.cast(identity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESRequest.Builder, CopyableBuilder<Builder, DeleteIdentityRequest> {
        /**
         * <p>
         * The identity to be removed from the list of identities for the AWS Account.
         * </p>
         * 
         * @param identity
         *        The identity to be removed from the list of identities for the AWS Account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SESRequest.BuilderImpl implements Builder {
        private String identity;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIdentityRequest model) {
            super(model);
            identity(model.identity);
        }

        public final String getIdentity() {
            return identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteIdentityRequest build() {
            return new DeleteIdentityRequest(this);
        }
    }
}
