/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the custom MAIL FROM domain attributes of a verified identity (email address or domain).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class IdentityMailFromDomainAttributes implements
        ToCopyableBuilder<IdentityMailFromDomainAttributes.Builder, IdentityMailFromDomainAttributes> {
    private final String mailFromDomain;

    private final String mailFromDomainStatus;

    private final String behaviorOnMXFailure;

    private IdentityMailFromDomainAttributes(BuilderImpl builder) {
        this.mailFromDomain = builder.mailFromDomain;
        this.mailFromDomainStatus = builder.mailFromDomainStatus;
        this.behaviorOnMXFailure = builder.behaviorOnMXFailure;
    }

    /**
     * <p>
     * The custom MAIL FROM domain that the identity is configured to use.
     * </p>
     * 
     * @return The custom MAIL FROM domain that the identity is configured to use.
     */
    public String mailFromDomain() {
        return mailFromDomain;
    }

    /**
     * <p>
     * The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL FROM
     * domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM domain when
     * the verified identity sends an email. All other states indicate that Amazon SES takes the action described by
     * <code>BehaviorOnMXFailure</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mailFromDomainStatus} will return {@link CustomMailFromStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mailFromDomainStatusAsString}.
     * </p>
     * 
     * @return The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL
     *         FROM domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM
     *         domain when the verified identity sends an email. All other states indicate that Amazon SES takes the
     *         action described by <code>BehaviorOnMXFailure</code>.
     * @see CustomMailFromStatus
     */
    public CustomMailFromStatus mailFromDomainStatus() {
        return CustomMailFromStatus.fromValue(mailFromDomainStatus);
    }

    /**
     * <p>
     * The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL FROM
     * domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM domain when
     * the verified identity sends an email. All other states indicate that Amazon SES takes the action described by
     * <code>BehaviorOnMXFailure</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mailFromDomainStatus} will return {@link CustomMailFromStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mailFromDomainStatusAsString}.
     * </p>
     * 
     * @return The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL
     *         FROM domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM
     *         domain when the verified identity sends an email. All other states indicate that Amazon SES takes the
     *         action described by <code>BehaviorOnMXFailure</code>.
     * @see CustomMailFromStatus
     */
    public String mailFromDomainStatusAsString() {
        return mailFromDomainStatus;
    }

    /**
     * <p>
     * The action that Amazon SES takes if it cannot successfully read the required MX record when you send an email. A
     * value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX record, it uses
     * amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of <code>RejectMessage</code> indicates
     * that if Amazon SES cannot read the required MX record, Amazon SES returns a
     * <code>MailFromDomainNotVerified</code> error and does not send the email.
     * </p>
     * <p>
     * The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>, <code>Failed</code>, and
     * <code>TemporaryFailure</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #behaviorOnMXFailure} will return {@link BehaviorOnMXFailure#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #behaviorOnMXFailureAsString}.
     * </p>
     * 
     * @return The action that Amazon SES takes if it cannot successfully read the required MX record when you send an
     *         email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX
     *         record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
     *         <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
     *         returns a <code>MailFromDomainNotVerified</code> error and does not send the email.</p>
     *         <p>
     *         The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>,
     *         <code>Failed</code>, and <code>TemporaryFailure</code>.
     * @see BehaviorOnMXFailure
     */
    public BehaviorOnMXFailure behaviorOnMXFailure() {
        return BehaviorOnMXFailure.fromValue(behaviorOnMXFailure);
    }

    /**
     * <p>
     * The action that Amazon SES takes if it cannot successfully read the required MX record when you send an email. A
     * value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX record, it uses
     * amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of <code>RejectMessage</code> indicates
     * that if Amazon SES cannot read the required MX record, Amazon SES returns a
     * <code>MailFromDomainNotVerified</code> error and does not send the email.
     * </p>
     * <p>
     * The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>, <code>Failed</code>, and
     * <code>TemporaryFailure</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #behaviorOnMXFailure} will return {@link BehaviorOnMXFailure#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #behaviorOnMXFailureAsString}.
     * </p>
     * 
     * @return The action that Amazon SES takes if it cannot successfully read the required MX record when you send an
     *         email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX
     *         record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
     *         <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
     *         returns a <code>MailFromDomainNotVerified</code> error and does not send the email.</p>
     *         <p>
     *         The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>,
     *         <code>Failed</code>, and <code>TemporaryFailure</code>.
     * @see BehaviorOnMXFailure
     */
    public String behaviorOnMXFailureAsString() {
        return behaviorOnMXFailure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mailFromDomain());
        hashCode = 31 * hashCode + Objects.hashCode(mailFromDomainStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(behaviorOnMXFailureAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityMailFromDomainAttributes)) {
            return false;
        }
        IdentityMailFromDomainAttributes other = (IdentityMailFromDomainAttributes) obj;
        return Objects.equals(mailFromDomain(), other.mailFromDomain())
                && Objects.equals(mailFromDomainStatusAsString(), other.mailFromDomainStatusAsString())
                && Objects.equals(behaviorOnMXFailureAsString(), other.behaviorOnMXFailureAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("IdentityMailFromDomainAttributes").add("MailFromDomain", mailFromDomain())
                .add("MailFromDomainStatus", mailFromDomainStatusAsString())
                .add("BehaviorOnMXFailure", behaviorOnMXFailureAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MailFromDomain":
            return Optional.of(clazz.cast(mailFromDomain()));
        case "MailFromDomainStatus":
            return Optional.of(clazz.cast(mailFromDomainStatusAsString()));
        case "BehaviorOnMXFailure":
            return Optional.of(clazz.cast(behaviorOnMXFailureAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, IdentityMailFromDomainAttributes> {
        /**
         * <p>
         * The custom MAIL FROM domain that the identity is configured to use.
         * </p>
         * 
         * @param mailFromDomain
         *        The custom MAIL FROM domain that the identity is configured to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailFromDomain(String mailFromDomain);

        /**
         * <p>
         * The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL FROM
         * domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM domain
         * when the verified identity sends an email. All other states indicate that Amazon SES takes the action
         * described by <code>BehaviorOnMXFailure</code>.
         * </p>
         * 
         * @param mailFromDomainStatus
         *        The state that indicates whether Amazon SES has successfully read the MX record required for custom
         *        MAIL FROM domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom
         *        MAIL FROM domain when the verified identity sends an email. All other states indicate that Amazon SES
         *        takes the action described by <code>BehaviorOnMXFailure</code>.
         * @see CustomMailFromStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomMailFromStatus
         */
        Builder mailFromDomainStatus(String mailFromDomainStatus);

        /**
         * <p>
         * The state that indicates whether Amazon SES has successfully read the MX record required for custom MAIL FROM
         * domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom MAIL FROM domain
         * when the verified identity sends an email. All other states indicate that Amazon SES takes the action
         * described by <code>BehaviorOnMXFailure</code>.
         * </p>
         * 
         * @param mailFromDomainStatus
         *        The state that indicates whether Amazon SES has successfully read the MX record required for custom
         *        MAIL FROM domain setup. If the state is <code>Success</code>, Amazon SES uses the specified custom
         *        MAIL FROM domain when the verified identity sends an email. All other states indicate that Amazon SES
         *        takes the action described by <code>BehaviorOnMXFailure</code>.
         * @see CustomMailFromStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomMailFromStatus
         */
        Builder mailFromDomainStatus(CustomMailFromStatus mailFromDomainStatus);

        /**
         * <p>
         * The action that Amazon SES takes if it cannot successfully read the required MX record when you send an
         * email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX
         * record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
         * <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
         * returns a <code>MailFromDomainNotVerified</code> error and does not send the email.
         * </p>
         * <p>
         * The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>, <code>Failed</code>,
         * and <code>TemporaryFailure</code>.
         * </p>
         * 
         * @param behaviorOnMXFailure
         *        The action that Amazon SES takes if it cannot successfully read the required MX record when you send
         *        an email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the
         *        required MX record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
         *        <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
         *        returns a <code>MailFromDomainNotVerified</code> error and does not send the email.</p>
         *        <p>
         *        The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>,
         *        <code>Failed</code>, and <code>TemporaryFailure</code>.
         * @see BehaviorOnMXFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorOnMXFailure
         */
        Builder behaviorOnMXFailure(String behaviorOnMXFailure);

        /**
         * <p>
         * The action that Amazon SES takes if it cannot successfully read the required MX record when you send an
         * email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the required MX
         * record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
         * <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
         * returns a <code>MailFromDomainNotVerified</code> error and does not send the email.
         * </p>
         * <p>
         * The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>, <code>Failed</code>,
         * and <code>TemporaryFailure</code>.
         * </p>
         * 
         * @param behaviorOnMXFailure
         *        The action that Amazon SES takes if it cannot successfully read the required MX record when you send
         *        an email. A value of <code>UseDefaultValue</code> indicates that if Amazon SES cannot read the
         *        required MX record, it uses amazonses.com (or a subdomain of that) as the MAIL FROM domain. A value of
         *        <code>RejectMessage</code> indicates that if Amazon SES cannot read the required MX record, Amazon SES
         *        returns a <code>MailFromDomainNotVerified</code> error and does not send the email.</p>
         *        <p>
         *        The custom MAIL FROM setup states that result in this behavior are <code>Pending</code>,
         *        <code>Failed</code>, and <code>TemporaryFailure</code>.
         * @see BehaviorOnMXFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorOnMXFailure
         */
        Builder behaviorOnMXFailure(BehaviorOnMXFailure behaviorOnMXFailure);
    }

    static final class BuilderImpl implements Builder {
        private String mailFromDomain;

        private String mailFromDomainStatus;

        private String behaviorOnMXFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityMailFromDomainAttributes model) {
            mailFromDomain(model.mailFromDomain);
            mailFromDomainStatus(model.mailFromDomainStatus);
            behaviorOnMXFailure(model.behaviorOnMXFailure);
        }

        public final String getMailFromDomain() {
            return mailFromDomain;
        }

        @Override
        public final Builder mailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
            return this;
        }

        public final void setMailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
        }

        public final String getMailFromDomainStatus() {
            return mailFromDomainStatus;
        }

        @Override
        public final Builder mailFromDomainStatus(String mailFromDomainStatus) {
            this.mailFromDomainStatus = mailFromDomainStatus;
            return this;
        }

        @Override
        public final Builder mailFromDomainStatus(CustomMailFromStatus mailFromDomainStatus) {
            this.mailFromDomainStatus(mailFromDomainStatus.toString());
            return this;
        }

        public final void setMailFromDomainStatus(String mailFromDomainStatus) {
            this.mailFromDomainStatus = mailFromDomainStatus;
        }

        public final String getBehaviorOnMXFailure() {
            return behaviorOnMXFailure;
        }

        @Override
        public final Builder behaviorOnMXFailure(String behaviorOnMXFailure) {
            this.behaviorOnMXFailure = behaviorOnMXFailure;
            return this;
        }

        @Override
        public final Builder behaviorOnMXFailure(BehaviorOnMXFailure behaviorOnMXFailure) {
            this.behaviorOnMXFailure(behaviorOnMXFailure.toString());
            return this;
        }

        public final void setBehaviorOnMXFailure(String behaviorOnMXFailure) {
            this.behaviorOnMXFailure = behaviorOnMXFailure;
        }

        @Override
        public IdentityMailFromDomainAttributes build() {
            return new IdentityMailFromDomainAttributes(this);
        }
    }
}
