/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that the provided Amazon S3 bucket or AWS KMS encryption key is invalid, or that Amazon SES could not
 * publish to the bucket, possibly due to permissions issues. For information about giving permissions, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InvalidS3ConfigurationException extends SESException implements
        ToCopyableBuilder<InvalidS3ConfigurationException.Builder, InvalidS3ConfigurationException> {
    private final String bucket;

    private InvalidS3ConfigurationException(BuilderImpl builder) {
        super(builder.message);
        this.bucket = builder.bucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * Indicated that the S3 Bucket was not found.
     * </p>
     * 
     * @return Indicated that the S3 Bucket was not found.
     */
    public String bucket() {
        return bucket;
    }

    public interface Builder extends CopyableBuilder<Builder, InvalidS3ConfigurationException> {
        /**
         * <p>
         * Indicated that the S3 Bucket was not found.
         * </p>
         * 
         * @param bucket
         *        Indicated that the S3 Bucket was not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidS3ConfigurationException model) {
            bucket(model.bucket);
            this.message = model.getMessage();
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public InvalidS3ConfigurationException build() {
            return new InvalidS3ConfigurationException(this);
        }
    }
}
