/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTemplatesResponse extends SESResponse implements
        ToCopyableBuilder<ListTemplatesResponse.Builder, ListTemplatesResponse> {
    private final List<TemplateMetadata> templatesMetadata;

    private final String nextToken;

    private ListTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.templatesMetadata = builder.templatesMetadata;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array the contains the name of creation time stamp for each template in your Amazon SES account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array the contains the name of creation time stamp for each template in your Amazon SES account.
     */
    public List<TemplateMetadata> templatesMetadata() {
        return templatesMetadata;
    }

    /**
     * <p>
     * The token to use for pagination.
     * </p>
     * 
     * @return The token to use for pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templatesMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplatesResponse)) {
            return false;
        }
        ListTemplatesResponse other = (ListTemplatesResponse) obj;
        return Objects.equals(templatesMetadata(), other.templatesMetadata()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListTemplatesResponse").add("TemplatesMetadata", templatesMetadata())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplatesMetadata":
            return Optional.of(clazz.cast(templatesMetadata()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESResponse.Builder, CopyableBuilder<Builder, ListTemplatesResponse> {
        /**
         * <p>
         * An array the contains the name of creation time stamp for each template in your Amazon SES account.
         * </p>
         * 
         * @param templatesMetadata
         *        An array the contains the name of creation time stamp for each template in your Amazon SES account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templatesMetadata(Collection<TemplateMetadata> templatesMetadata);

        /**
         * <p>
         * An array the contains the name of creation time stamp for each template in your Amazon SES account.
         * </p>
         * 
         * @param templatesMetadata
         *        An array the contains the name of creation time stamp for each template in your Amazon SES account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templatesMetadata(TemplateMetadata... templatesMetadata);

        /**
         * <p>
         * An array the contains the name of creation time stamp for each template in your Amazon SES account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TemplateMetadata>.Builder} avoiding the
         * need to create one manually via {@link List<TemplateMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TemplateMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #templatesMetadata(List<TemplateMetadata>)}.
         * 
         * @param templatesMetadata
         *        a consumer that will call methods on {@link List<TemplateMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templatesMetadata(List<TemplateMetadata>)
         */
        Builder templatesMetadata(Consumer<TemplateMetadata.Builder>... templatesMetadata);

        /**
         * <p>
         * The token to use for pagination.
         * </p>
         * 
         * @param nextToken
         *        The token to use for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SESResponse.BuilderImpl implements Builder {
        private List<TemplateMetadata> templatesMetadata;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplatesResponse model) {
            super(model);
            templatesMetadata(model.templatesMetadata);
            nextToken(model.nextToken);
        }

        public final Collection<TemplateMetadata.Builder> getTemplatesMetadata() {
            return templatesMetadata != null ? templatesMetadata.stream().map(TemplateMetadata::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder templatesMetadata(Collection<TemplateMetadata> templatesMetadata) {
            this.templatesMetadata = TemplateMetadataListCopier.copy(templatesMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templatesMetadata(TemplateMetadata... templatesMetadata) {
            templatesMetadata(Arrays.asList(templatesMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templatesMetadata(Consumer<TemplateMetadata.Builder>... templatesMetadata) {
            templatesMetadata(Stream.of(templatesMetadata).map(c -> TemplateMetadata.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTemplatesMetadata(Collection<TemplateMetadata.BuilderImpl> templatesMetadata) {
            this.templatesMetadata = TemplateMetadataListCopier.copyFromBuilder(templatesMetadata);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTemplatesResponse build() {
            return new ListTemplatesResponse(this);
        }
    }
}
