/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to set a receipt rule set as the active receipt rule set. You use receipt rule sets to receive
 * email with Amazon SES. For more information, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SetActiveReceiptRuleSetRequest extends SESRequest implements
        ToCopyableBuilder<SetActiveReceiptRuleSetRequest.Builder, SetActiveReceiptRuleSetRequest> {
    private final String ruleSetName;

    private SetActiveReceiptRuleSetRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetName = builder.ruleSetName;
    }

    /**
     * <p>
     * The name of the receipt rule set to make active. Setting this value to null disables all email receiving.
     * </p>
     * 
     * @return The name of the receipt rule set to make active. Setting this value to null disables all email receiving.
     */
    public String ruleSetName() {
        return ruleSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetActiveReceiptRuleSetRequest)) {
            return false;
        }
        SetActiveReceiptRuleSetRequest other = (SetActiveReceiptRuleSetRequest) obj;
        return Objects.equals(ruleSetName(), other.ruleSetName());
    }

    @Override
    public String toString() {
        return ToString.builder("SetActiveReceiptRuleSetRequest").add("RuleSetName", ruleSetName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSetName":
            return Optional.of(clazz.cast(ruleSetName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESRequest.Builder, CopyableBuilder<Builder, SetActiveReceiptRuleSetRequest> {
        /**
         * <p>
         * The name of the receipt rule set to make active. Setting this value to null disables all email receiving.
         * </p>
         * 
         * @param ruleSetName
         *        The name of the receipt rule set to make active. Setting this value to null disables all email
         *        receiving.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetName(String ruleSetName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SESRequest.BuilderImpl implements Builder {
        private String ruleSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SetActiveReceiptRuleSetRequest model) {
            super(model);
            ruleSetName(model.ruleSetName);
        }

        public final String getRuleSetName() {
            return ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SetActiveReceiptRuleSetRequest build() {
            return new SetActiveReceiptRuleSetRequest(this);
        }
    }
}
