/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content of the email, composed of a subject line, an HTML part, and a text-only part.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Template implements ToCopyableBuilder<Template.Builder, Template> {
    private final String templateName;

    private final String subjectPart;

    private final String textPart;

    private final String htmlPart;

    private Template(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.subjectPart = builder.subjectPart;
        this.textPart = builder.textPart;
        this.htmlPart = builder.htmlPart;
    }

    /**
     * <p>
     * The name of the template. You will refer to this name when you send email using the
     * <code>SendTemplatedEmail</code> or <code>SendBulkTemplatedEmail</code> operations.
     * </p>
     * 
     * @return The name of the template. You will refer to this name when you send email using the
     *         <code>SendTemplatedEmail</code> or <code>SendBulkTemplatedEmail</code> operations.
     */
    public String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The subject line of the email.
     * </p>
     * 
     * @return The subject line of the email.
     */
    public String subjectPart() {
        return subjectPart;
    }

    /**
     * <p>
     * The email body that will be visible to recipients whose email clients do not display HTML.
     * </p>
     * 
     * @return The email body that will be visible to recipients whose email clients do not display HTML.
     */
    public String textPart() {
        return textPart;
    }

    /**
     * <p>
     * The HTML body of the email.
     * </p>
     * 
     * @return The HTML body of the email.
     */
    public String htmlPart() {
        return htmlPart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(subjectPart());
        hashCode = 31 * hashCode + Objects.hashCode(textPart());
        hashCode = 31 * hashCode + Objects.hashCode(htmlPart());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Template)) {
            return false;
        }
        Template other = (Template) obj;
        return Objects.equals(templateName(), other.templateName()) && Objects.equals(subjectPart(), other.subjectPart())
                && Objects.equals(textPart(), other.textPart()) && Objects.equals(htmlPart(), other.htmlPart());
    }

    @Override
    public String toString() {
        return ToString.builder("Template").add("TemplateName", templateName()).add("SubjectPart", subjectPart())
                .add("TextPart", textPart()).add("HtmlPart", htmlPart()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateName":
            return Optional.of(clazz.cast(templateName()));
        case "SubjectPart":
            return Optional.of(clazz.cast(subjectPart()));
        case "TextPart":
            return Optional.of(clazz.cast(textPart()));
        case "HtmlPart":
            return Optional.of(clazz.cast(htmlPart()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Template> {
        /**
         * <p>
         * The name of the template. You will refer to this name when you send email using the
         * <code>SendTemplatedEmail</code> or <code>SendBulkTemplatedEmail</code> operations.
         * </p>
         * 
         * @param templateName
         *        The name of the template. You will refer to this name when you send email using the
         *        <code>SendTemplatedEmail</code> or <code>SendBulkTemplatedEmail</code> operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The subject line of the email.
         * </p>
         * 
         * @param subjectPart
         *        The subject line of the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectPart(String subjectPart);

        /**
         * <p>
         * The email body that will be visible to recipients whose email clients do not display HTML.
         * </p>
         * 
         * @param textPart
         *        The email body that will be visible to recipients whose email clients do not display HTML.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textPart(String textPart);

        /**
         * <p>
         * The HTML body of the email.
         * </p>
         * 
         * @param htmlPart
         *        The HTML body of the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder htmlPart(String htmlPart);
    }

    static final class BuilderImpl implements Builder {
        private String templateName;

        private String subjectPart;

        private String textPart;

        private String htmlPart;

        private BuilderImpl() {
        }

        private BuilderImpl(Template model) {
            templateName(model.templateName);
            subjectPart(model.subjectPart);
            textPart(model.textPart);
            htmlPart(model.htmlPart);
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getSubjectPart() {
            return subjectPart;
        }

        @Override
        public final Builder subjectPart(String subjectPart) {
            this.subjectPart = subjectPart;
            return this;
        }

        public final void setSubjectPart(String subjectPart) {
            this.subjectPart = subjectPart;
        }

        public final String getTextPart() {
            return textPart;
        }

        @Override
        public final Builder textPart(String textPart) {
            this.textPart = textPart;
            return this;
        }

        public final void setTextPart(String textPart) {
            this.textPart = textPart;
        }

        public final String getHtmlPart() {
            return htmlPart;
        }

        @Override
        public final Builder htmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
            return this;
        }

        public final void setHtmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
        }

        @Override
        public Template build() {
            return new Template(this);
        }
    }
}
