/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class TestRenderTemplateRequest extends SESRequest implements
        ToCopyableBuilder<TestRenderTemplateRequest.Builder, TestRenderTemplateRequest> {
    private final String templateName;

    private final String templateData;

    private TestRenderTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.templateData = builder.templateData;
    }

    /**
     * <p>
     * The name of the template that you want to render.
     * </p>
     * 
     * @return The name of the template that you want to render.
     */
    public String templateName() {
        return templateName;
    }

    /**
     * <p>
     * A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of
     * key-value pairs in which the keys correspond to replacement tags in the email template.
     * </p>
     * 
     * @return A list of replacement values to apply to the template. This parameter is a JSON object, typically
     *         consisting of key-value pairs in which the keys correspond to replacement tags in the email template.
     */
    public String templateData() {
        return templateData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestRenderTemplateRequest)) {
            return false;
        }
        TestRenderTemplateRequest other = (TestRenderTemplateRequest) obj;
        return Objects.equals(templateName(), other.templateName()) && Objects.equals(templateData(), other.templateData());
    }

    @Override
    public String toString() {
        return ToString.builder("TestRenderTemplateRequest").add("TemplateName", templateName())
                .add("TemplateData", templateData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateName":
            return Optional.of(clazz.cast(templateName()));
        case "TemplateData":
            return Optional.of(clazz.cast(templateData()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESRequest.Builder, CopyableBuilder<Builder, TestRenderTemplateRequest> {
        /**
         * <p>
         * The name of the template that you want to render.
         * </p>
         * 
         * @param templateName
         *        The name of the template that you want to render.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting
         * of key-value pairs in which the keys correspond to replacement tags in the email template.
         * </p>
         * 
         * @param templateData
         *        A list of replacement values to apply to the template. This parameter is a JSON object, typically
         *        consisting of key-value pairs in which the keys correspond to replacement tags in the email template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateData(String templateData);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SESRequest.BuilderImpl implements Builder {
        private String templateName;

        private String templateData;

        private BuilderImpl() {
        }

        private BuilderImpl(TestRenderTemplateRequest model) {
            super(model);
            templateName(model.templateName);
            templateData(model.templateData);
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getTemplateData() {
            return templateData;
        }

        @Override
        public final Builder templateData(String templateData) {
            this.templateData = templateData;
            return this;
        }

        public final void setTemplateData(String templateData) {
            this.templateData = templateData;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public TestRenderTemplateRequest build() {
            return new TestRenderTemplateRequest(this);
        }
    }
}
