/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to enable or disable the email sending capabilities for your entire Amazon SES account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateAccountSendingEnabledRequest extends SESRequest implements
        ToCopyableBuilder<UpdateAccountSendingEnabledRequest.Builder, UpdateAccountSendingEnabledRequest> {
    private final Boolean enabled;

    private UpdateAccountSendingEnabledRequest(BuilderImpl builder) {
        super(builder);
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * Describes whether email sending is enabled or disabled for your Amazon SES account.
     * </p>
     * 
     * @return Describes whether email sending is enabled or disabled for your Amazon SES account.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountSendingEnabledRequest)) {
            return false;
        }
        UpdateAccountSendingEnabledRequest other = (UpdateAccountSendingEnabledRequest) obj;
        return Objects.equals(enabled(), other.enabled());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateAccountSendingEnabledRequest").add("Enabled", enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.of(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESRequest.Builder, CopyableBuilder<Builder, UpdateAccountSendingEnabledRequest> {
        /**
         * <p>
         * Describes whether email sending is enabled or disabled for your Amazon SES account.
         * </p>
         * 
         * @param enabled
         *        Describes whether email sending is enabled or disabled for your Amazon SES account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SESRequest.BuilderImpl implements Builder {
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountSendingEnabledRequest model) {
            super(model);
            enabled(model.enabled);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountSendingEnabledRequest build() {
            return new UpdateAccountSendingEnabledRequest(this);
        }
    }
}
