/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns CNAME records that you must publish to the DNS server of your domain to set up Easy DKIM with Amazon SES.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VerifyDomainDkimResponse extends SESResponse implements
        ToCopyableBuilder<VerifyDomainDkimResponse.Builder, VerifyDomainDkimResponse> {
    private final List<String> dkimTokens;

    private VerifyDomainDkimResponse(BuilderImpl builder) {
        super(builder);
        this.dkimTokens = builder.dkimTokens;
    }

    /**
     * <p>
     * A set of character strings that represent the domain's identity. If the identity is an email address, the tokens
     * represent the domain of that address.
     * </p>
     * <p>
     * Using these tokens, you will need to create DNS CNAME records that point to DKIM public keys hosted by Amazon
     * SES. Amazon Web Services will eventually detect that you have updated your DNS records; this detection process
     * may take up to 72 hours. Upon successful detection, Amazon SES will be able to DKIM-sign emails originating from
     * that domain.
     * </p>
     * <p>
     * For more information about creating DNS records using DKIM tokens, go to the <a
     * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer
     * Guide</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A set of character strings that represent the domain's identity. If the identity is an email address, the
     *         tokens represent the domain of that address.</p>
     *         <p>
     *         Using these tokens, you will need to create DNS CNAME records that point to DKIM public keys hosted by
     *         Amazon SES. Amazon Web Services will eventually detect that you have updated your DNS records; this
     *         detection process may take up to 72 hours. Upon successful detection, Amazon SES will be able to
     *         DKIM-sign emails originating from that domain.
     *         </p>
     *         <p>
     *         For more information about creating DNS records using DKIM tokens, go to the <a
     *         href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES
     *         Developer Guide</a>.
     */
    public List<String> dkimTokens() {
        return dkimTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dkimTokens());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyDomainDkimResponse)) {
            return false;
        }
        VerifyDomainDkimResponse other = (VerifyDomainDkimResponse) obj;
        return Objects.equals(dkimTokens(), other.dkimTokens());
    }

    @Override
    public String toString() {
        return ToString.builder("VerifyDomainDkimResponse").add("DkimTokens", dkimTokens()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DkimTokens":
            return Optional.of(clazz.cast(dkimTokens()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SESResponse.Builder, CopyableBuilder<Builder, VerifyDomainDkimResponse> {
        /**
         * <p>
         * A set of character strings that represent the domain's identity. If the identity is an email address, the
         * tokens represent the domain of that address.
         * </p>
         * <p>
         * Using these tokens, you will need to create DNS CNAME records that point to DKIM public keys hosted by Amazon
         * SES. Amazon Web Services will eventually detect that you have updated your DNS records; this detection
         * process may take up to 72 hours. Upon successful detection, Amazon SES will be able to DKIM-sign emails
         * originating from that domain.
         * </p>
         * <p>
         * For more information about creating DNS records using DKIM tokens, go to the <a
         * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer
         * Guide</a>.
         * </p>
         * 
         * @param dkimTokens
         *        A set of character strings that represent the domain's identity. If the identity is an email address,
         *        the tokens represent the domain of that address.</p>
         *        <p>
         *        Using these tokens, you will need to create DNS CNAME records that point to DKIM public keys hosted by
         *        Amazon SES. Amazon Web Services will eventually detect that you have updated your DNS records; this
         *        detection process may take up to 72 hours. Upon successful detection, Amazon SES will be able to
         *        DKIM-sign emails originating from that domain.
         *        </p>
         *        <p>
         *        For more information about creating DNS records using DKIM tokens, go to the <a
         *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES
         *        Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dkimTokens(Collection<String> dkimTokens);

        /**
         * <p>
         * A set of character strings that represent the domain's identity. If the identity is an email address, the
         * tokens represent the domain of that address.
         * </p>
         * <p>
         * Using these tokens, you will need to create DNS CNAME records that point to DKIM public keys hosted by Amazon
         * SES. Amazon Web Services will eventually detect that you have updated your DNS records; this detection
         * process may take up to 72 hours. Upon successful detection, Amazon SES will be able to DKIM-sign emails
         * originating from that domain.
         * </p>
         * <p>
         * For more information about creating DNS records using DKIM tokens, go to the <a
         * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES Developer
         * Guide</a>.
         * </p>
         * 
         * @param dkimTokens
         *        A set of character strings that represent the domain's identity. If the identity is an email address,
         *        the tokens represent the domain of that address.</p>
         *        <p>
         *        Using these tokens, you will need to create DNS CNAME records that point to DKIM public keys hosted by
         *        Amazon SES. Amazon Web Services will eventually detect that you have updated your DNS records; this
         *        detection process may take up to 72 hours. Upon successful detection, Amazon SES will be able to
         *        DKIM-sign emails originating from that domain.
         *        </p>
         *        <p>
         *        For more information about creating DNS records using DKIM tokens, go to the <a
         *        href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html">Amazon SES
         *        Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dkimTokens(String... dkimTokens);
    }

    static final class BuilderImpl extends SESResponse.BuilderImpl implements Builder {
        private List<String> dkimTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyDomainDkimResponse model) {
            super(model);
            dkimTokens(model.dkimTokens);
        }

        public final Collection<String> getDkimTokens() {
            return dkimTokens;
        }

        @Override
        public final Builder dkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dkimTokens(String... dkimTokens) {
            dkimTokens(Arrays.asList(dkimTokens));
            return this;
        }

        public final void setDkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = VerificationTokenListCopier.copy(dkimTokens);
        }

        @Override
        public VerifyDomainDkimResponse build() {
            return new VerifyDomainDkimResponse(this);
        }
    }
}
