/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * ReceiptAction StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ReceiptActionUnmarshaller implements Unmarshaller<ReceiptAction, StaxUnmarshallerContext> {

    public ReceiptAction unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReceiptAction.Builder receiptAction = ReceiptAction.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("S3Action", targetDepth)) {
                    receiptAction.s3Action(S3ActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("BounceAction", targetDepth)) {
                    receiptAction.bounceAction(BounceActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("WorkmailAction", targetDepth)) {
                    receiptAction.workmailAction(WorkmailActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("LambdaAction", targetDepth)) {
                    receiptAction.lambdaAction(LambdaActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StopAction", targetDepth)) {
                    receiptAction.stopAction(StopActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AddHeaderAction", targetDepth)) {
                    receiptAction.addHeaderAction(AddHeaderActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("SNSAction", targetDepth)) {
                    receiptAction.snsAction(SNSActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return receiptAction.build();
    }

    private static final ReceiptActionUnmarshaller INSTANCE = new ReceiptActionUnmarshaller();

    public static ReceiptActionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
