/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * UpdateReceiptRuleRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateReceiptRuleRequestMarshaller implements
        Marshaller<Request<UpdateReceiptRuleRequest>, UpdateReceiptRuleRequest> {

    public Request<UpdateReceiptRuleRequest> marshall(UpdateReceiptRuleRequest updateReceiptRuleRequest) {

        if (updateReceiptRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<UpdateReceiptRuleRequest> request = new DefaultRequest<UpdateReceiptRuleRequest>(updateReceiptRuleRequest,
                "SESClient");
        request.addParameter("Action", "UpdateReceiptRule");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (updateReceiptRuleRequest.ruleSetName() != null) {
            request.addParameter("RuleSetName", StringUtils.fromString(updateReceiptRuleRequest.ruleSetName()));
        }

        ReceiptRule rule = updateReceiptRuleRequest.rule();
        if (rule != null) {

            if (rule.name() != null) {
                request.addParameter("Rule.Name", StringUtils.fromString(rule.name()));
            }

            if (rule.enabled() != null) {
                request.addParameter("Rule.Enabled", StringUtils.fromBoolean(rule.enabled()));
            }

            if (rule.tlsPolicyAsString() != null) {
                request.addParameter("Rule.TlsPolicy", StringUtils.fromString(rule.tlsPolicyAsString()));
            }

            java.util.List<String> recipientsList = rule.recipients();

            if (recipientsList != null) {
                if (!recipientsList.isEmpty()) {
                    int recipientsListIndex = 1;

                    for (String recipientsListValue : recipientsList) {
                        if (recipientsListValue != null) {
                            request.addParameter("Rule.Recipients.member." + recipientsListIndex,
                                    StringUtils.fromString(recipientsListValue));
                        }
                        recipientsListIndex++;
                    }
                } else {
                    request.addParameter("Rule.Recipients", "");
                }
            }

            java.util.List<ReceiptAction> actionsList = rule.actions();

            if (actionsList != null) {
                if (!actionsList.isEmpty()) {
                    int actionsListIndex = 1;

                    for (ReceiptAction actionsListValue : actionsList) {

                        S3Action s3Action = actionsListValue.s3Action();
                        if (s3Action != null) {

                            if (s3Action.topicArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.TopicArn",
                                        StringUtils.fromString(s3Action.topicArn()));
                            }

                            if (s3Action.bucketName() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.BucketName",
                                        StringUtils.fromString(s3Action.bucketName()));
                            }

                            if (s3Action.objectKeyPrefix() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.ObjectKeyPrefix",
                                        StringUtils.fromString(s3Action.objectKeyPrefix()));
                            }

                            if (s3Action.kmsKeyArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.KmsKeyArn",
                                        StringUtils.fromString(s3Action.kmsKeyArn()));
                            }
                        }

                        BounceAction bounceAction = actionsListValue.bounceAction();
                        if (bounceAction != null) {

                            if (bounceAction.topicArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.TopicArn",
                                        StringUtils.fromString(bounceAction.topicArn()));
                            }

                            if (bounceAction.smtpReplyCode() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.SmtpReplyCode",
                                        StringUtils.fromString(bounceAction.smtpReplyCode()));
                            }

                            if (bounceAction.statusCode() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.StatusCode",
                                        StringUtils.fromString(bounceAction.statusCode()));
                            }

                            if (bounceAction.message() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.Message",
                                        StringUtils.fromString(bounceAction.message()));
                            }

                            if (bounceAction.sender() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.Sender",
                                        StringUtils.fromString(bounceAction.sender()));
                            }
                        }

                        WorkmailAction workmailAction = actionsListValue.workmailAction();
                        if (workmailAction != null) {

                            if (workmailAction.topicArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".WorkmailAction.TopicArn",
                                        StringUtils.fromString(workmailAction.topicArn()));
                            }

                            if (workmailAction.organizationArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex
                                        + ".WorkmailAction.OrganizationArn",
                                        StringUtils.fromString(workmailAction.organizationArn()));
                            }
                        }

                        LambdaAction lambdaAction = actionsListValue.lambdaAction();
                        if (lambdaAction != null) {

                            if (lambdaAction.topicArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.TopicArn",
                                        StringUtils.fromString(lambdaAction.topicArn()));
                            }

                            if (lambdaAction.functionArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.FunctionArn",
                                        StringUtils.fromString(lambdaAction.functionArn()));
                            }

                            if (lambdaAction.invocationTypeAsString() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.InvocationType",
                                        StringUtils.fromString(lambdaAction.invocationTypeAsString()));
                            }
                        }

                        StopAction stopAction = actionsListValue.stopAction();
                        if (stopAction != null) {

                            if (stopAction.scopeAsString() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".StopAction.Scope",
                                        StringUtils.fromString(stopAction.scopeAsString()));
                            }

                            if (stopAction.topicArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".StopAction.TopicArn",
                                        StringUtils.fromString(stopAction.topicArn()));
                            }
                        }

                        AddHeaderAction addHeaderAction = actionsListValue.addHeaderAction();
                        if (addHeaderAction != null) {

                            if (addHeaderAction.headerName() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".AddHeaderAction.HeaderName",
                                        StringUtils.fromString(addHeaderAction.headerName()));
                            }

                            if (addHeaderAction.headerValue() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".AddHeaderAction.HeaderValue",
                                        StringUtils.fromString(addHeaderAction.headerValue()));
                            }
                        }

                        SNSAction snsAction = actionsListValue.snsAction();
                        if (snsAction != null) {

                            if (snsAction.topicArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".SNSAction.TopicArn",
                                        StringUtils.fromString(snsAction.topicArn()));
                            }

                            if (snsAction.encodingAsString() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".SNSAction.Encoding",
                                        StringUtils.fromString(snsAction.encodingAsString()));
                            }
                        }
                        actionsListIndex++;
                    }
                } else {
                    request.addParameter("Rule.Actions", "");
                }
            }

            if (rule.scanEnabled() != null) {
                request.addParameter("Rule.ScanEnabled", StringUtils.fromBoolean(rule.scanEnabled()));
            }
        }

        return request;
    }

}
