/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of email addresses that you have verified with Amazon SES under your AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVerifiedEmailAddressesResponse extends SesResponse implements
        ToCopyableBuilder<ListVerifiedEmailAddressesResponse.Builder, ListVerifiedEmailAddressesResponse> {
    private final List<String> verifiedEmailAddresses;

    private ListVerifiedEmailAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.verifiedEmailAddresses = builder.verifiedEmailAddresses;
    }

    /**
     * <p>
     * A list of email addresses that have been verified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of email addresses that have been verified.
     */
    public List<String> verifiedEmailAddresses() {
        return verifiedEmailAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(verifiedEmailAddresses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVerifiedEmailAddressesResponse)) {
            return false;
        }
        ListVerifiedEmailAddressesResponse other = (ListVerifiedEmailAddressesResponse) obj;
        return Objects.equals(verifiedEmailAddresses(), other.verifiedEmailAddresses());
    }

    @Override
    public String toString() {
        return ToString.builder("ListVerifiedEmailAddressesResponse").add("VerifiedEmailAddresses", verifiedEmailAddresses())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedEmailAddresses":
            return Optional.ofNullable(clazz.cast(verifiedEmailAddresses()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SesResponse.Builder, CopyableBuilder<Builder, ListVerifiedEmailAddressesResponse> {
        /**
         * <p>
         * A list of email addresses that have been verified.
         * </p>
         * 
         * @param verifiedEmailAddresses
         *        A list of email addresses that have been verified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedEmailAddresses(Collection<String> verifiedEmailAddresses);

        /**
         * <p>
         * A list of email addresses that have been verified.
         * </p>
         * 
         * @param verifiedEmailAddresses
         *        A list of email addresses that have been verified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedEmailAddresses(String... verifiedEmailAddresses);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private List<String> verifiedEmailAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVerifiedEmailAddressesResponse model) {
            super(model);
            verifiedEmailAddresses(model.verifiedEmailAddresses);
        }

        public final Collection<String> getVerifiedEmailAddresses() {
            return verifiedEmailAddresses;
        }

        @Override
        public final Builder verifiedEmailAddresses(Collection<String> verifiedEmailAddresses) {
            this.verifiedEmailAddresses = AddressListCopier.copy(verifiedEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedEmailAddresses(String... verifiedEmailAddresses) {
            verifiedEmailAddresses(Arrays.asList(verifiedEmailAddresses));
            return this;
        }

        public final void setVerifiedEmailAddresses(Collection<String> verifiedEmailAddresses) {
            this.verifiedEmailAddresses = AddressListCopier.copy(verifiedEmailAddresses);
        }

        @Override
        public ListVerifiedEmailAddressesResponse build() {
            return new ListVerifiedEmailAddressesResponse(this);
        }
    }
}
