/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * DescribeReceiptRuleSetRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeReceiptRuleSetRequestMarshaller implements
        Marshaller<Request<DescribeReceiptRuleSetRequest>, DescribeReceiptRuleSetRequest> {

    public Request<DescribeReceiptRuleSetRequest> marshall(DescribeReceiptRuleSetRequest describeReceiptRuleSetRequest) {

        if (describeReceiptRuleSetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<DescribeReceiptRuleSetRequest> request = new DefaultRequest<DescribeReceiptRuleSetRequest>(
                describeReceiptRuleSetRequest, "SesClient");
        request.addParameter("Action", "DescribeReceiptRuleSet");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (describeReceiptRuleSetRequest.ruleSetName() != null) {
            request.addParameter("RuleSetName", StringConversion.fromString(describeReceiptRuleSetRequest.ruleSetName()));
        }

        return request;
    }

}
