/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * GetIdentityNotificationAttributesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetIdentityNotificationAttributesRequestMarshaller implements
        Marshaller<Request<GetIdentityNotificationAttributesRequest>, GetIdentityNotificationAttributesRequest> {

    public Request<GetIdentityNotificationAttributesRequest> marshall(
            GetIdentityNotificationAttributesRequest getIdentityNotificationAttributesRequest) {

        if (getIdentityNotificationAttributesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<GetIdentityNotificationAttributesRequest> request = new DefaultRequest<GetIdentityNotificationAttributesRequest>(
                getIdentityNotificationAttributesRequest, "SesClient");
        request.addParameter("Action", "GetIdentityNotificationAttributes");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (getIdentityNotificationAttributesRequest.identities().isEmpty()
                && !(getIdentityNotificationAttributesRequest.identities() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Identities", "");
        } else if (!getIdentityNotificationAttributesRequest.identities().isEmpty()
                && !(getIdentityNotificationAttributesRequest.identities() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> identitiesList = getIdentityNotificationAttributesRequest.identities();
            int identitiesListIndex = 1;

            for (String identitiesListValue : identitiesList) {
                if (identitiesListValue != null) {
                    request.addParameter("Identities.member." + identitiesListIndex,
                            StringConversion.fromString(identitiesListValue));
                }
                identitiesListIndex++;
            }
        }

        return request;
    }

}
