/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * SendRawEmailRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SendRawEmailRequestMarshaller implements Marshaller<Request<SendRawEmailRequest>, SendRawEmailRequest> {

    public Request<SendRawEmailRequest> marshall(SendRawEmailRequest sendRawEmailRequest) {

        if (sendRawEmailRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<SendRawEmailRequest> request = new DefaultRequest<SendRawEmailRequest>(sendRawEmailRequest, "SesClient");
        request.addParameter("Action", "SendRawEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (sendRawEmailRequest.source() != null) {
            request.addParameter("Source", StringConversion.fromString(sendRawEmailRequest.source()));
        }

        if (sendRawEmailRequest.destinations().isEmpty()
                && !(sendRawEmailRequest.destinations() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Destinations", "");
        } else if (!sendRawEmailRequest.destinations().isEmpty()
                && !(sendRawEmailRequest.destinations() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> destinationsList = sendRawEmailRequest.destinations();
            int destinationsListIndex = 1;

            for (String destinationsListValue : destinationsList) {
                if (destinationsListValue != null) {
                    request.addParameter("Destinations.member." + destinationsListIndex,
                            StringConversion.fromString(destinationsListValue));
                }
                destinationsListIndex++;
            }
        }

        RawMessage rawMessage = sendRawEmailRequest.rawMessage();
        if (rawMessage != null) {

            if (rawMessage.data() != null) {
                request.addParameter("RawMessage.Data", StringConversion.fromSdkBytes(rawMessage.data()));
            }
        }

        if (sendRawEmailRequest.fromArn() != null) {
            request.addParameter("FromArn", StringConversion.fromString(sendRawEmailRequest.fromArn()));
        }

        if (sendRawEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringConversion.fromString(sendRawEmailRequest.sourceArn()));
        }

        if (sendRawEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringConversion.fromString(sendRawEmailRequest.returnPathArn()));
        }

        if (sendRawEmailRequest.tags().isEmpty()
                && !(sendRawEmailRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!sendRawEmailRequest.tags().isEmpty()
                && !(sendRawEmailRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<MessageTag> tagsList = sendRawEmailRequest.tags();
            int tagsListIndex = 1;

            for (MessageTag tagsListValue : tagsList) {

                if (tagsListValue.name() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Name",
                            StringConversion.fromString(tagsListValue.name()));
                }

                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value",
                            StringConversion.fromString(tagsListValue.value()));
                }
                tagsListIndex++;
            }
        }

        if (sendRawEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringConversion.fromString(sendRawEmailRequest.configurationSetName()));
        }

        return request;
    }

}
