/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * SendTemplatedEmailRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SendTemplatedEmailRequestMarshaller implements
        Marshaller<Request<SendTemplatedEmailRequest>, SendTemplatedEmailRequest> {

    public Request<SendTemplatedEmailRequest> marshall(SendTemplatedEmailRequest sendTemplatedEmailRequest) {

        if (sendTemplatedEmailRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<SendTemplatedEmailRequest> request = new DefaultRequest<SendTemplatedEmailRequest>(sendTemplatedEmailRequest,
                "SesClient");
        request.addParameter("Action", "SendTemplatedEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (sendTemplatedEmailRequest.source() != null) {
            request.addParameter("Source", StringConversion.fromString(sendTemplatedEmailRequest.source()));
        }

        Destination destination = sendTemplatedEmailRequest.destination();
        if (destination != null) {

            if (destination.toAddresses().isEmpty()
                    && !(destination.toAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                request.addParameter("Destination.ToAddresses", "");
            } else if (!destination.toAddresses().isEmpty()
                    && !(destination.toAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                java.util.List<String> toAddressesList = destination.toAddresses();
                int toAddressesListIndex = 1;

                for (String toAddressesListValue : toAddressesList) {
                    if (toAddressesListValue != null) {
                        request.addParameter("Destination.ToAddresses.member." + toAddressesListIndex,
                                StringConversion.fromString(toAddressesListValue));
                    }
                    toAddressesListIndex++;
                }
            }

            if (destination.ccAddresses().isEmpty()
                    && !(destination.ccAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                request.addParameter("Destination.CcAddresses", "");
            } else if (!destination.ccAddresses().isEmpty()
                    && !(destination.ccAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                java.util.List<String> ccAddressesList = destination.ccAddresses();
                int ccAddressesListIndex = 1;

                for (String ccAddressesListValue : ccAddressesList) {
                    if (ccAddressesListValue != null) {
                        request.addParameter("Destination.CcAddresses.member." + ccAddressesListIndex,
                                StringConversion.fromString(ccAddressesListValue));
                    }
                    ccAddressesListIndex++;
                }
            }

            if (destination.bccAddresses().isEmpty()
                    && !(destination.bccAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                request.addParameter("Destination.BccAddresses", "");
            } else if (!destination.bccAddresses().isEmpty()
                    && !(destination.bccAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                java.util.List<String> bccAddressesList = destination.bccAddresses();
                int bccAddressesListIndex = 1;

                for (String bccAddressesListValue : bccAddressesList) {
                    if (bccAddressesListValue != null) {
                        request.addParameter("Destination.BccAddresses.member." + bccAddressesListIndex,
                                StringConversion.fromString(bccAddressesListValue));
                    }
                    bccAddressesListIndex++;
                }
            }
        }

        if (sendTemplatedEmailRequest.replyToAddresses().isEmpty()
                && !(sendTemplatedEmailRequest.replyToAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("ReplyToAddresses", "");
        } else if (!sendTemplatedEmailRequest.replyToAddresses().isEmpty()
                && !(sendTemplatedEmailRequest.replyToAddresses() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> replyToAddressesList = sendTemplatedEmailRequest.replyToAddresses();
            int replyToAddressesListIndex = 1;

            for (String replyToAddressesListValue : replyToAddressesList) {
                if (replyToAddressesListValue != null) {
                    request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex,
                            StringConversion.fromString(replyToAddressesListValue));
                }
                replyToAddressesListIndex++;
            }
        }

        if (sendTemplatedEmailRequest.returnPath() != null) {
            request.addParameter("ReturnPath", StringConversion.fromString(sendTemplatedEmailRequest.returnPath()));
        }

        if (sendTemplatedEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringConversion.fromString(sendTemplatedEmailRequest.sourceArn()));
        }

        if (sendTemplatedEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringConversion.fromString(sendTemplatedEmailRequest.returnPathArn()));
        }

        if (sendTemplatedEmailRequest.tags().isEmpty()
                && !(sendTemplatedEmailRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!sendTemplatedEmailRequest.tags().isEmpty()
                && !(sendTemplatedEmailRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<MessageTag> tagsList = sendTemplatedEmailRequest.tags();
            int tagsListIndex = 1;

            for (MessageTag tagsListValue : tagsList) {

                if (tagsListValue.name() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Name",
                            StringConversion.fromString(tagsListValue.name()));
                }

                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value",
                            StringConversion.fromString(tagsListValue.value()));
                }
                tagsListIndex++;
            }
        }

        if (sendTemplatedEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName",
                    StringConversion.fromString(sendTemplatedEmailRequest.configurationSetName()));
        }

        if (sendTemplatedEmailRequest.template() != null) {
            request.addParameter("Template", StringConversion.fromString(sendTemplatedEmailRequest.template()));
        }

        if (sendTemplatedEmailRequest.templateArn() != null) {
            request.addParameter("TemplateArn", StringConversion.fromString(sendTemplatedEmailRequest.templateArn()));
        }

        if (sendTemplatedEmailRequest.templateData() != null) {
            request.addParameter("TemplateData", StringConversion.fromString(sendTemplatedEmailRequest.templateData()));
        }

        return request;
    }

}
