/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.IdentityListCopier;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdentityVerificationAttributesRequest
extends SesRequest
implements ToCopyableBuilder<Builder, GetIdentityVerificationAttributesRequest> {
    private final List<String> identities;

    private GetIdentityVerificationAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.identities = builder.identities;
    }

    public List<String> identities() {
        return this.identities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identities());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityVerificationAttributesRequest)) {
            return false;
        }
        GetIdentityVerificationAttributesRequest other = (GetIdentityVerificationAttributesRequest)((Object)obj);
        return Objects.equals(this.identities(), other.identities());
    }

    public String toString() {
        return ToString.builder((String)"GetIdentityVerificationAttributesRequest").add("Identities", this.identities()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identities": {
                return Optional.ofNullable(clazz.cast(this.identities()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private List<String> identities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityVerificationAttributesRequest model) {
            super(model);
            this.identities(model.identities);
        }

        public final Collection<String> getIdentities() {
            return this.identities;
        }

        @Override
        public final Builder identities(Collection<String> identities) {
            this.identities = IdentityListCopier.copy(identities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identities(String ... identities) {
            this.identities(Arrays.asList(identities));
            return this;
        }

        public final void setIdentities(Collection<String> identities) {
            this.identities = IdentityListCopier.copy(identities);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIdentityVerificationAttributesRequest build() {
            return new GetIdentityVerificationAttributesRequest(this);
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    CopyableBuilder<Builder, GetIdentityVerificationAttributesRequest> {
        public Builder identities(Collection<String> var1);

        public Builder identities(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

