/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetIdentityDkimEnabledRequest
extends SesRequest
implements ToCopyableBuilder<Builder, SetIdentityDkimEnabledRequest> {
    private final String identity;
    private final Boolean dkimEnabled;

    private SetIdentityDkimEnabledRequest(BuilderImpl builder) {
        super(builder);
        this.identity = builder.identity;
        this.dkimEnabled = builder.dkimEnabled;
    }

    public String identity() {
        return this.identity;
    }

    public Boolean dkimEnabled() {
        return this.dkimEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identity());
        hashCode = 31 * hashCode + Objects.hashCode(this.dkimEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIdentityDkimEnabledRequest)) {
            return false;
        }
        SetIdentityDkimEnabledRequest other = (SetIdentityDkimEnabledRequest)((Object)obj);
        return Objects.equals(this.identity(), other.identity()) && Objects.equals(this.dkimEnabled(), other.dkimEnabled());
    }

    public String toString() {
        return ToString.builder((String)"SetIdentityDkimEnabledRequest").add("Identity", (Object)this.identity()).add("DkimEnabled", (Object)this.dkimEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identity": {
                return Optional.ofNullable(clazz.cast(this.identity()));
            }
            case "DkimEnabled": {
                return Optional.ofNullable(clazz.cast(this.dkimEnabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String identity;
        private Boolean dkimEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(SetIdentityDkimEnabledRequest model) {
            super(model);
            this.identity(model.identity);
            this.dkimEnabled(model.dkimEnabled);
        }

        public final String getIdentity() {
            return this.identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final Boolean getDkimEnabled() {
            return this.dkimEnabled;
        }

        @Override
        public final Builder dkimEnabled(Boolean dkimEnabled) {
            this.dkimEnabled = dkimEnabled;
            return this;
        }

        public final void setDkimEnabled(Boolean dkimEnabled) {
            this.dkimEnabled = dkimEnabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetIdentityDkimEnabledRequest build() {
            return new SetIdentityDkimEnabledRequest(this);
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    CopyableBuilder<Builder, SetIdentityDkimEnabledRequest> {
        public Builder identity(String var1);

        public Builder dkimEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

