/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.AddHeaderAction;

public class AddHeaderActionUnmarshaller
implements Unmarshaller<AddHeaderAction, StaxUnmarshallerContext> {
    private static final AddHeaderActionUnmarshaller INSTANCE = new AddHeaderActionUnmarshaller();

    public AddHeaderAction unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        AddHeaderAction.Builder addHeaderAction = AddHeaderAction.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("HeaderName", targetDepth)) {
                    addHeaderAction.headerName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("HeaderValue", targetDepth)) continue;
                addHeaderAction.headerValue(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (AddHeaderAction)addHeaderAction.build();
    }

    public static AddHeaderActionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

